/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Lists;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.util.LightingHelper;
import gregtech.common.render.GTRenderUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class GTUtilityClient {
    private static final Field isDrawingField = ReflectionHelper.findField(Tessellator.class, (String[])new String[]{"isDrawing", "field_78415_z"});

    public static boolean isDrawing(Tessellator tess) {
        try {
            return isDrawingField.getBoolean(tess);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<String> getTooltip(ItemStack aStack, boolean aGuiStyle) {
        try {
            List tooltip = aStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            if (aGuiStyle) {
                tooltip.set(0, (aStack.func_77953_t() == null ? EnumRarity.common : aStack.func_77953_t()).field_77937_e + (String)tooltip.get(0));
                for (int i = 1; i < tooltip.size(); ++i) {
                    tooltip.set(i, EnumChatFormatting.GRAY + (String)tooltip.get(i));
                }
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            if (aGuiStyle) {
                return Lists.newArrayList((Object[])new String[]{(aStack.func_77953_t() == null ? EnumRarity.common : aStack.func_77953_t()).field_77937_e + aStack.func_82833_r()});
            }
            return Lists.newArrayList((Object[])new String[]{aStack.func_82833_r()});
        }
    }

    public static void renderTurbineOverlay(IBlockAccess aWorld, int aX, int aY, int aZ, RenderBlocks aRenderer, ExtendedFacing tExtendedFacing, Block tBlockOverride, IIconContainer[] tTextures) {
        int[] tABCCoord = new int[]{-1, -1, 0};
        int[] tXYZOffset = new int[3];
        ForgeDirection tDirection = tExtendedFacing.getDirection();
        tExtendedFacing = ExtendedFacing.of((ForgeDirection)tDirection);
        LightingHelper tLighting = new LightingHelper(aRenderer);
        if (tDirection == ForgeDirection.NORTH || tDirection == ForgeDirection.EAST) {
            aRenderer.field_152631_f = true;
        }
        for (int i = 0; i < 9; ++i) {
            tExtendedFacing.getWorldOffset(tABCCoord, tXYZOffset);
            int tX = tXYZOffset[0] + aX;
            int tY = tXYZOffset[1] + aY;
            int tZ = tXYZOffset[2] + aZ;
            Block tBlock = tBlockOverride == null ? aWorld.func_147439_a(aX + tDirection.offsetX, tY + tDirection.offsetY, aZ + tDirection.offsetZ) : tBlockOverride;
            Tessellator.field_78398_a.func_78380_c(tBlock.func_149677_c(aWorld, aX + tDirection.offsetX, tY + tDirection.offsetY, aZ + tDirection.offsetZ));
            tLighting.setupLighting(tBlock, tX, tY, tZ, tDirection).setupColor(tDirection, Dyes._NULL.mRGBa);
            GTRenderUtil.renderBlockIcon(aRenderer, tBlock, (double)tX + (double)tDirection.offsetX * 0.001, (double)tY + (double)tDirection.offsetY * 0.001, (double)tZ + (double)tDirection.offsetZ * 0.001, tTextures[i].getIcon(), tDirection);
            tABCCoord[0] = tABCCoord[0] + 1;
            if (tABCCoord[0] != 2) continue;
            tABCCoord[0] = -1;
            tABCCoord[1] = tABCCoord[1] + 1;
        }
        aRenderer.field_152631_f = false;
    }
}

