/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import gregtech.common.tileentities.machines.IDualInputHatch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class GTUtil {
    public static final ThreadLocal<TileEntity> LAST_BROKEN_TILEENTITY = new ThreadLocal();

    public static Tuple tuple(String key, Object value) {
        return new Tuple((Object)key, value);
    }

    public static NBTTagCompound fuseNBT(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        if (nbt1 == null) {
            return nbt2 == null ? new NBTTagCompound() : (NBTTagCompound)nbt2.func_74737_b();
        }
        NBTTagCompound rNBT = (NBTTagCompound)nbt1.func_74737_b();
        if (nbt2 == null) {
            return rNBT;
        }
        for (Object tKey : nbt2.func_150296_c()) {
            if (rNBT.func_74764_b(tKey.toString())) continue;
            rNBT.func_74782_a(tKey.toString(), nbt2.func_74781_a(tKey.toString()));
        }
        return rNBT;
    }

    public static NBTTagCompound makeNBT(Tuple ... tags) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Tuple t : tags) {
            if (t.func_76340_b() == null) continue;
            if (t.func_76340_b() instanceof Boolean) {
                nbt.func_74757_a(t.func_76341_a().toString(), ((Boolean)t.func_76340_b()).booleanValue());
                continue;
            }
            if (t.func_76340_b() instanceof Byte) {
                nbt.func_74774_a(t.func_76341_a().toString(), ((Byte)t.func_76340_b()).byteValue());
                continue;
            }
            if (t.func_76340_b() instanceof Short) {
                nbt.func_74777_a(t.func_76341_a().toString(), ((Short)t.func_76340_b()).shortValue());
                continue;
            }
            if (t.func_76340_b() instanceof Integer) {
                nbt.func_74768_a(t.func_76341_a().toString(), ((Integer)t.func_76340_b()).intValue());
                continue;
            }
            if (t.func_76340_b() instanceof Long) {
                nbt.func_74772_a(t.func_76341_a().toString(), ((Long)t.func_76340_b()).longValue());
                continue;
            }
            if (t.func_76340_b() instanceof Float) {
                nbt.func_74776_a(t.func_76341_a().toString(), ((Float)t.func_76340_b()).floatValue());
                continue;
            }
            if (t.func_76340_b() instanceof Double) {
                nbt.func_74780_a(t.func_76341_a().toString(), ((Double)t.func_76340_b()).doubleValue());
                continue;
            }
            if (t.func_76340_b() instanceof String) {
                nbt.func_74778_a(t.func_76341_a().toString(), (String)t.func_76340_b());
                continue;
            }
            if (t.func_76340_b() instanceof NBTBase) {
                nbt.func_74782_a(t.func_76341_a().toString(), (NBTBase)t.func_76340_b());
                continue;
            }
            nbt.func_74778_a(t.func_76341_a().toString(), t.func_76340_b().toString());
        }
        return nbt;
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z, boolean aLoadUnloadedChunks) {
        if (aLoadUnloadedChunks || world.func_72899_e(x, y, z)) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IMultiTileEntity && ((IMultiTileEntity)tileEntity).isDead()) {
                return null;
            }
            if (tileEntity != null) {
                return tileEntity;
            }
            tileEntity = LAST_BROKEN_TILEENTITY.get();
            if (tileEntity != null && tileEntity.field_145851_c == x && tileEntity.field_145848_d == y && tileEntity.field_145849_e == z) {
                return tileEntity;
            }
        }
        return null;
    }

    public static TileEntity setTileEntity(World world, int x, int y, int z, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
        if (aCauseTileEntityUpdates) {
            world.func_147455_a(x, y, z, aTileEntity);
        } else {
            Chunk tChunk = world.func_72964_e(x >> 4, z >> 4);
            if (tChunk != null) {
                world.addTileEntity(aTileEntity);
                tChunk.func_150812_a(x & 0xF, y, z & 0xF, aTileEntity);
                tChunk.func_76630_e();
            }
        }
        return aTileEntity;
    }

    public static boolean setBlock(World world, int x, int y, int z, Block block, short aMeta, long aFlags, boolean aRemoveGrassBelow) {
        Block blockBelow;
        if (aRemoveGrassBelow && ((blockBelow = world.func_147439_a(x, y - 1, z)) == Blocks.field_150349_c || blockBelow == Blocks.field_150391_bh)) {
            world.func_147465_d(x, y - 1, z, Blocks.field_150346_d, 0, (int)((byte)aFlags));
        }
        return world.func_147465_d(x, y, z, block, (int)aMeta, (int)((byte)aFlags));
    }

    public static TileEntity getTileEntity(World world, ChunkCoordinates coords, boolean loadUnloadedChunks) {
        return GTUtil.getTileEntity(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, loadUnloadedChunks);
    }

    public static boolean markChunkDirty(World world, int x, int z) {
        if (world == null || world.field_72995_K) {
            return false;
        }
        Chunk aChunk = world.func_72938_d(x, z);
        if (aChunk == null) {
            world.func_72805_g(x, 0, z);
            aChunk = world.func_72938_d(x, z);
            if (aChunk == null) {
                GTLog.err.println("Some important Chunk does not exist for some reason at Coordinates X: " + x + " and Z: " + z);
                return false;
            }
        }
        aChunk.func_76630_e();
        return true;
    }

    public static boolean markChunkDirty(Object maybeTile) {
        TileEntity tileEntity;
        return maybeTile instanceof TileEntity && GTUtil.markChunkDirty((tileEntity = (TileEntity)maybeTile).func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145849_e);
    }

    public static int mixRGBInt(int aRGB1, int aRGB2) {
        return GTUtil.getRGBInt(new short[]{(short)(GTUtil.getR(aRGB1) + GTUtil.getR(aRGB2) >> 1), (short)(GTUtil.getG(aRGB1) + GTUtil.getG(aRGB2) >> 1), (short)(GTUtil.getB(aRGB1) + GTUtil.getB(aRGB2) >> 1)});
    }

    public static int getRGBInt(short[] aColors) {
        return aColors == null ? 0xFFFFFF : aColors[0] << 16 | aColors[1] << 8 | aColors[2];
    }

    public static int getRGBaInt(short[] aColors) {
        return aColors == null ? 0xFFFFFF : aColors[0] << 16 | aColors[1] << 8 | aColors[2] | aColors[3] << 24;
    }

    public static String toHexString(short[] aColors) {
        return aColors == null ? "FFFFFF" : Integer.toHexString(aColors[0] << 16 | aColors[1] << 8 | aColors[2]);
    }

    public static int getRGBInt(short aR, short aG, short aB) {
        return aR << 16 | aG << 8 | aB;
    }

    public static int getRGBaInt(short aR, short aG, short aB, short aA) {
        return aR << 16 | aG << 8 | aB | aA << 24;
    }

    public static short[] getRGBaArray(int aColors) {
        return new short[]{(short)(aColors >>> 16 & 0xFF), (short)(aColors >>> 8 & 0xFF), (short)(aColors & 0xFF), (short)(aColors >>> 24 & 0xFF)};
    }

    public static short getR(int aColors) {
        return (short)(aColors >>> 16 & 0xFF);
    }

    public static short getG(int aColors) {
        return (short)(aColors >>> 8 & 0xFF);
    }

    public static short getB(int aColors) {
        return (short)(aColors & 0xFF);
    }

    public static short getA(int aColors) {
        return (short)(aColors >>> 24 & 0xFF);
    }

    public static boolean saveMultiblockInputConfiguration(MTEMultiBlockBase controller, EntityPlayer player) {
        NBTTagCompound newTag = new NBTTagCompound();
        ItemStack dataOrb = player.func_70694_bm();
        if (GTUtility.isStackInvalid(dataOrb) || !ItemList.Tool_DataOrb.isStackEqual(dataOrb, false, true)) {
            return false;
        }
        if (!controller.saveOtherHatchConfiguration(player)) {
            return false;
        }
        newTag.func_74778_a("type", "MultiblockConfiguration");
        int count = 0;
        NBTTagList list = GTUtil.saveConfigurationToDataStick(player, controller.mInputBusses);
        if (list == null) {
            return false;
        }
        newTag.func_74782_a("mInputBusses", (NBTBase)list);
        count += list.func_74745_c();
        list = GTUtil.saveConfigurationToDataStick(player, controller.mInputHatches);
        if (list == null) {
            return false;
        }
        newTag.func_74782_a("mInputHatches", (NBTBase)list);
        count += list.func_74745_c();
        list = GTUtil.saveConfigurationToDataStick(player, controller.mOutputBusses);
        if (list == null) {
            return false;
        }
        newTag.func_74782_a("mOutputBusses", (NBTBase)list);
        count += list.func_74745_c();
        ArrayList<MTEHatch> dualInputHatches = new ArrayList<MTEHatch>();
        for (IDualInputHatch dualInputHatch : controller.mDualInputHatches) {
            if (!(dualInputHatch instanceof MTEHatch)) continue;
            MTEHatch hatch = (MTEHatch)((Object)dualInputHatch);
            dualInputHatches.add(hatch);
        }
        list = GTUtil.saveConfigurationToDataStick(player, dualInputHatches);
        if (list == null) {
            return false;
        }
        newTag.func_74782_a("mDualInputHatches", (NBTBase)list);
        dataOrb.func_77982_d(newTag);
        BehaviourDataOrb.setDataTitle(dataOrb, "Multiblock Hatch Configuration");
        BehaviourDataOrb.setDataName(dataOrb, String.format("%s configuration saved", count += list.func_74745_c()));
        return true;
    }

    public static boolean hasMultiblockInputConfiguration(ItemStack dataOrb) {
        return !GTUtility.isStackInvalid(dataOrb) && ItemList.Tool_DataOrb.isStackEqual(dataOrb, false, true) && dataOrb.func_77978_p() != null && "MultiblockConfiguration".equals(dataOrb.func_77978_p().func_74779_i("type"));
    }

    public static boolean loadMultiblockInputConfiguration(MTEMultiBlockBase controller, EntityPlayer player) {
        ItemStack dataOrb = player.func_70694_bm();
        if (!GTUtil.hasMultiblockInputConfiguration(dataOrb)) {
            return false;
        }
        if (!controller.loadOtherHatchConfiguration(player)) {
            return false;
        }
        NBTTagCompound tag = dataOrb.func_77978_p();
        if (GTUtil.checkCanLoadConfigurationFromDataStick(tag.func_150295_c("mInputBusses", 10), player, controller.mInputBusses) && !GTUtil.loadConfigurationFromDataStick(tag.func_150295_c("mInputBusses", 10), player, controller.mInputBusses)) {
            return false;
        }
        if (GTUtil.checkCanLoadConfigurationFromDataStick(tag.func_150295_c("mInputHatches", 10), player, controller.mInputHatches) && !GTUtil.loadConfigurationFromDataStick(tag.func_150295_c("mInputHatches", 10), player, controller.mInputHatches)) {
            return false;
        }
        if (GTUtil.checkCanLoadConfigurationFromDataStick(tag.func_150295_c("mOutputBusses", 10), player, controller.mOutputBusses) && !GTUtil.loadConfigurationFromDataStick(tag.func_150295_c("mOutputBusses", 10), player, controller.mOutputBusses)) {
            return false;
        }
        ArrayList<MTEHatch> dualInputHatches = new ArrayList<MTEHatch>();
        for (IDualInputHatch dualInputHatch : controller.mDualInputHatches) {
            if (!(dualInputHatch instanceof MTEHatch)) continue;
            MTEHatch hatch = (MTEHatch)((Object)dualInputHatch);
            dualInputHatches.add(hatch);
        }
        if (GTUtil.checkCanLoadConfigurationFromDataStick(tag.func_150295_c("mDualInputHatches", 10), player, dualInputHatches)) {
            return GTUtil.loadConfigurationFromDataStick(tag.func_150295_c("mDualInputHatches", 10), player, dualInputHatches);
        }
        return true;
    }

    private static NBTTagList saveConfigurationToDataStick(EntityPlayer player, List<? extends MTEHatch> hatches) {
        NBTTagList list = new NBTTagList();
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            if (!(tHatch instanceof IDataCopyable)) {
                list.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            IDataCopyable copyable = (IDataCopyable)((Object)tHatch);
            NBTTagCompound tag = copyable.getCopiedData(player);
            if (tag == null) {
                return null;
            }
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    private static boolean loadConfigurationFromDataStick(NBTTagList list, EntityPlayer player, List<? extends MTEHatch> hatches) {
        if (list == null || list.field_74747_a.isEmpty()) {
            return false;
        }
        List<? extends MTEHatch> validMTEs = GTUtility.filterValidMTEs(hatches);
        int end = Math.min(validMTEs.size(), list.func_74745_c());
        for (int i = 0; i < end; ++i) {
            MTEHatch tHatch = validMTEs.get(i);
            NBTTagCompound tag = list.func_150305_b(i);
            if (!(tHatch instanceof IDataCopyable)) {
                if (tag.func_82582_d()) continue;
                return false;
            }
            IDataCopyable copyable = (IDataCopyable)((Object)tHatch);
            if (tag.func_82582_d()) {
                return false;
            }
            if (copyable.pasteCopiedData(player, tag)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCanLoadConfigurationFromDataStick(NBTTagList list, EntityPlayer player, List<? extends MTEHatch> hatches) {
        if (list == null || list.field_74747_a.isEmpty()) {
            return false;
        }
        List<? extends MTEHatch> validMTEs = GTUtility.filterValidMTEs(hatches);
        int end = Math.min(validMTEs.size(), list.func_74745_c());
        for (int i = 0; i < end; ++i) {
            IDataCopyable copyable;
            MTEHatch tHatch = validMTEs.get(i);
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_82582_d() || tHatch instanceof IDataCopyable && (copyable = (IDataCopyable)((Object)tHatch)).getCopiedDataIdentifier(player).equals(tag.func_74779_i("type"))) continue;
            return false;
        }
        return true;
    }
}

