/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.ISerializableObject;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class CoverBehavior
extends CoverBehaviorBase<ISerializableObject.LegacyCoverData> {
    public boolean mPlayerNotified = false;

    public CoverBehavior() {
        this((ITexture)null);
    }

    public CoverBehavior(ITexture coverTexture) {
        super(ISerializableObject.LegacyCoverData.class, coverTexture);
    }

    protected static int convert(ISerializableObject.LegacyCoverData data) {
        return data == null ? 0 : data.get();
    }

    @Override
    public final ISerializableObject.LegacyCoverData createDataObject() {
        return new ISerializableObject.LegacyCoverData();
    }

    @Override
    public ISerializableObject.LegacyCoverData createDataObject(int aLegacyData) {
        return new ISerializableObject.LegacyCoverData(aLegacyData);
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.isRedstoneSensitive(side, aCoverID, aCoverVariable.get(), aTileEntity, aTimer);
    }

    @Override
    protected ISerializableObject.LegacyCoverData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == null) {
            aCoverVariable = new ISerializableObject.LegacyCoverData();
        }
        aCoverVariable.set(this.doCoverThings(side, aInputRedstone, aCoverID, aCoverVariable.get(), aTileEntity, aTimer));
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverRightclick(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    @Override
    protected ISerializableObject.LegacyCoverData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aCoverVariable == null) {
            aCoverVariable = new ISerializableObject.LegacyCoverData();
        }
        aCoverVariable.set(this.onCoverScrewdriverclick(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ));
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverShiftRightClickImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        return this.onCoverShiftRightclick(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity, aPlayer);
    }

    @Override
    protected boolean onCoverRemovalImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return this.onCoverRemoval(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity, aForced);
    }

    @Override
    protected void onBaseTEDestroyedImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        this.onBaseTEDestroyed(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected void onCoverUnloadImpl(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onCoverUnload(aTileEntity);
    }

    @Override
    protected String getDescriptionImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getDescription(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected float getBlastProofLevelImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getBlastProofLevel(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoIn(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoOut(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyIn(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyOut(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidIn(side, aCoverID, CoverBehavior.convert(aCoverVariable), aFluid, aTileEntity);
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidOut(side, aCoverID, CoverBehavior.convert(aCoverVariable), aFluid, aTileEntity);
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsIn(side, aCoverID, CoverBehavior.convert(aCoverVariable), aSlot, aTileEntity);
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsOut(side, aCoverID, CoverBehavior.convert(aCoverVariable), aSlot, aTileEntity);
    }

    @Override
    protected boolean isGUIClickableImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.isGUIClickable(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.manipulatesSidedRedstoneOutput(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.alwaysLookConnected(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected byte getRedstoneInputImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getRedstoneInput(side, aInputRedstone, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getTickRate(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected byte getLensColorImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getLensColor(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    @Override
    protected ItemStack getDropImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return this.getDrop(side, aCoverID, CoverBehavior.convert(aCoverVariable), aTileEntity);
    }

    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return true;
    }

    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    public boolean onCoverRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return aCoverVariable;
    }

    public boolean onCoverShiftRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        if (this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            this.lastPlayer = new WeakReference<EntityPlayer>(aPlayer);
            this.mPlayerNotified = false;
            GTUIInfos.openCoverUI(aTileEntity, aPlayer, side);
            return true;
        }
        return false;
    }

    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return true;
    }

    public void onCoverUnload(ICoverable aTileEntity) {
    }

    public void onBaseTEDestroyed(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
    }

    public String getDescription(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    public float getBlastProofLevel(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 10.0f;
    }

    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    public boolean isGUIClickable(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public byte getRedstoneInput(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoIn(side, aCoverID, aCoverVariable, aTileEntity) ? aInputRedstone : (byte)0;
    }

    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    public byte getLensColor(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return -1;
    }

    public ItemStack getDrop(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTOreDictUnificator.get(true, aTileEntity.getCoverItemAtSide(side));
    }
}

