/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.google.common.collect.Iterables;
import gregtech.api.recipe.RecipeMapBackendProperties;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeMapUtil;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class RecipeMapBackendPropertiesBuilder {
    private int minItemInputs;
    private int minFluidInputs;
    private boolean specialSlotSensitive;
    private boolean disableOptimize;
    private Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter = this::defaultBuildRecipe;
    @Nullable
    private Function<? super GTRecipe, ? extends GTRecipe> recipeTransformer;

    RecipeMapBackendPropertiesBuilder() {
    }

    RecipeMapBackendProperties build() {
        return new RecipeMapBackendProperties(this.minItemInputs, this.minFluidInputs, this.specialSlotSensitive, this.disableOptimize, this.recipeEmitter, this.recipeTransformer);
    }

    public RecipeMapBackendPropertiesBuilder minItemInputs(int minItemInputs) {
        this.minItemInputs = minItemInputs;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder minFluidInputs(int minFluidInputs) {
        this.minFluidInputs = minFluidInputs;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder specialSlotSensitive() {
        this.specialSlotSensitive = true;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder disableOptimize() {
        this.disableOptimize = true;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder recipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter) {
        this.recipeEmitter = recipeEmitter;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder combineRecipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> func) {
        Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> cur = this.recipeEmitter;
        return this.recipeEmitter(b -> Iterables.concat((Iterable)((Iterable)cur.apply((GTRecipeBuilder)b)), (Iterable)((Iterable)func.apply((GTRecipeBuilder)b))));
    }

    public RecipeMapBackendPropertiesBuilder recipeTransformer(Function<? super GTRecipe, ? extends GTRecipe> recipeTransformer) {
        this.recipeTransformer = recipeTransformer;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder chainRecipeTransformer(Function<? super GTRecipe, ? extends GTRecipe> func) {
        this.recipeTransformer = this.recipeTransformer == null ? func : this.recipeTransformer.andThen(func);
        return this;
    }

    private Iterable<? extends GTRecipe> defaultBuildRecipe(GTRecipeBuilder builder) {
        GTRecipeBuilder b = builder;
        if (this.disableOptimize && builder.isOptimize()) {
            b = RecipeMapBackendPropertiesBuilder.copy(builder, b).noOptimize();
        }
        return GTRecipeMapUtil.buildOrEmpty(b);
    }

    private static GTRecipeBuilder copy(GTRecipeBuilder original, GTRecipeBuilder b) {
        return b == original ? b.copy() : b;
    }
}

