/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import com.google.common.primitives.Ints;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.objects.overclockdescriber.EUNoOverclockDescriber;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUOverclockDescriber
extends EUNoOverclockDescriber {
    public EUOverclockDescriber(byte tier, int amperage) {
        super(tier, amperage);
    }

    @Override
    public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
        return template.setEUt(Ints.saturatedCast((long)(GTValues.V[this.tier] * (long)this.amperage)));
    }

    @Override
    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (!this.wasOverclocked(recipeInfo.calculator)) {
            super.drawEnergyInfoImpl(recipeInfo);
            return;
        }
        recipeInfo.drawText(GTUtility.trans("153", "Usage: ") + this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GTUtility.trans("154", "Voltage: ") + this.getVoltageString(recipeInfo.calculator));
        }
        if (GTMod.gregtechproxy.mNEIOriginalVoltage) {
            EUNoOverclockDescriber originalPower = new EUNoOverclockDescriber(this.tier, this.amperage);
            OverclockCalculator originalPowerCalculator = OverclockCalculator.ofNoOverclock(recipeInfo.recipe).calculate();
            recipeInfo.drawText(GTUtility.trans("275", "Original usage: ") + originalPower.getEUtDisplay(originalPowerCalculator));
        }
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GTUtility.trans("155", "Amperage: ") + this.getAmperageString(recipeInfo.calculator));
        }
    }

    @Override
    protected String getEUtWithoutTier(OverclockCalculator calculator) {
        return this.decorateWithOverclockLabel(super.getEUtWithoutTier(calculator), calculator);
    }

    @Override
    protected String getEUtWithTier(OverclockCalculator calculator) {
        return this.getEUtWithoutTier(calculator) + GTUtility.getTierNameWithParentheses(calculator.getConsumption());
    }

    @Override
    protected String getVoltageString(OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return this.decorateWithOverclockLabel(GTUtility.formatNumbers(voltage) + " EU/t", calculator) + GTUtility.getTierNameWithParentheses(voltage);
    }

    protected String decorateWithOverclockLabel(String s, OverclockCalculator calculator) {
        if (this.wasOverclocked(calculator)) {
            s = s + " (OC)";
        }
        return s;
    }

    protected boolean wasOverclocked(OverclockCalculator calculator) {
        return calculator.getPerformedOverclocks() > 0;
    }
}

