/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.multitileentity.multiblock.base.Controller;
import net.minecraft.item.ItemStack;

public abstract class StackableController<C extends StackableController<C, P>, P extends MuTEProcessingLogic<P>>
extends Controller<C, P> {
    protected static String STACKABLE_STOP = "STACKABLE_STOP";
    protected static String STACKABLE_MIDDLE = "STACKABLE_MIDDLE";
    protected static String STACKABLE_START = "STACKABLE_START";
    protected int stackCount = 0;

    public void construct(ItemStack trigger, boolean hintsOnly) {
        int blueprintCount = trigger.field_77994_a - 1 + this.getMinStacks();
        int stackCount = Math.min(blueprintCount, this.getMaxStacks());
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(this.getStackableStart(), trigger, hintsOnly, this.buildState.getCurrentOffset());
        this.buildState.addOffset(this.getStartingStackOffset());
        for (int i = 0; i < stackCount; ++i) {
            this.buildPiece(this.getStackableMiddle(i), trigger, hintsOnly, this.buildState.getCurrentOffset());
            this.buildState.addOffset(this.getPerStackOffset());
        }
        if (this.hasTop()) {
            this.buildState.addOffset(this.getAfterLastStackOffset());
            this.buildPiece(this.getStackableStop(), trigger, hintsOnly, this.buildState.stopBuilding());
        } else {
            this.buildState.stopBuilding();
        }
    }

    public abstract int getMinStacks();

    public abstract int getMaxStacks();

    public abstract Vec3Impl getStartingStackOffset();

    public abstract Vec3Impl getPerStackOffset();

    public boolean hasTop() {
        return true;
    }

    public Vec3Impl getAfterLastStackOffset() {
        return new Vec3Impl(0, 0, 0);
    }

    @Override
    public boolean checkMachine() {
        this.stackCount = 0;
        this.buildState.startBuilding(this.getStartingStructureOffset());
        if (!this.checkPiece(this.getStackableStart(), this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getStartingStackOffset());
        for (int i = 0; i < this.getMaxStacks() && this.checkPiece(this.getStackableMiddle(i), this.buildState.getCurrentOffset()); ++i) {
            this.buildState.addOffset(this.getPerStackOffset());
            ++this.stackCount;
        }
        if (this.stackCount < this.getMinStacks()) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getAfterLastStackOffset());
        if (!this.checkPiece(this.getStackableStop(), this.buildState.stopBuilding())) {
            return this.buildState.failBuilding();
        }
        return super.checkMachine();
    }

    protected String getStackableStop() {
        return STACKABLE_STOP;
    }

    protected String getStackableMiddle(int stackIndex) {
        return STACKABLE_MIDDLE;
    }

    protected String getStackableStart() {
        return STACKABLE_START;
    }
}

