/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.base;

import gregtech.GTMod;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.task.TaskHost;
import gregtech.api.task.TickableTask;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TickableMultiTileEntity
extends MultiTileEntity
implements TaskHost {
    public boolean isRunningTick = false;
    public boolean blockUpdated = false;
    protected long timer = 0L;
    private boolean sendClientData = false;
    private final Map<String, TickableTask<?>> tasks = new HashMap();

    public TickableMultiTileEntity() {
        super(true);
    }

    @Override
    public final void registerTask(@Nonnull TickableTask<?> task) {
        if (this.tasks.containsKey(task.getName())) {
            throw new IllegalStateException(String.format("Task with name %s is already registered", task.getName()));
        }
        this.tasks.put(task.getName(), task);
    }

    @Nullable
    public TickableTask<?> getTask(@Nonnull String name) {
        return this.tasks.get(name);
    }

    @Override
    public final void func_145845_h() {
        this.isRunningTick = true;
        boolean isServerSide = this.isServerSide();
        try {
            if (this.timer++ == 0L) {
                this.func_70296_d();
                GTUtil.markChunkDirty(this);
                this.onFirstTick(isServerSide);
            }
            if (this.isDead()) {
                return;
            }
            this.onPreTick(this.timer, isServerSide);
            super.func_145845_h();
            if (!isServerSide && this.needsUpdate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.needsUpdate = false;
            }
            this.onTick(this.timer, isServerSide);
            for (TickableTask<?> task : this.tasks.values()) {
                task.update(this.timer, isServerSide);
            }
            if (isServerSide && this.timer > 2L && this.sendClientData) {
                this.sendClientData(null);
            }
            this.onPostTick(this.timer, isServerSide);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("UpdateEntity Failed", e);
            e.printStackTrace(GTLog.err);
            try {
                this.onTickFailed(this.timer, isServerSide);
            }
            catch (Throwable e2) {
                GTMod.GT_FML_LOGGER.error("UpdateEntity:onTickFailed Failed", e);
            }
        }
        this.isRunningTick = false;
    }

    @Override
    public void sendClientData(EntityPlayerMP aPlayer) {
        if (this.sendClientData) {
            super.sendClientData(aPlayer);
            this.sendClientData = false;
        }
    }

    public void onFirstTick(boolean isServerSide) {
        if (isServerSide) {
            this.checkDropCover();
        } else {
            this.requestCoverDataIfNeeded();
        }
    }

    public void onPreTick(long tick, boolean isServerSide) {
    }

    public void onTick(long tick, boolean isServerSide) {
    }

    public void onPostTick(long tick, boolean isServerSide) {
    }

    public void onTickFailed(long tick, boolean isServerSide) {
    }

    @Override
    protected final void readTasksNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("gt.tasks")) {
            NBTTagCompound tasksTag = nbt.func_74775_l("gt.tasks");
            for (TickableTask<?> task : this.tasks.values()) {
                if (!tasksTag.func_74764_b(task.getName())) continue;
                task.readFromNBT(tasksTag.func_74775_l(task.getName()));
            }
        }
    }

    @Override
    protected final void writeTasksNBT(NBTTagCompound aNBT) {
        NBTTagCompound tasksTag = new NBTTagCompound();
        for (TickableTask<?> task : this.tasks.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            task.writeToNBT(tag);
            tasksTag.func_74782_a(task.getName(), (NBTBase)tag);
        }
        aNBT.func_74782_a("gt.tasks", (NBTBase)tasksTag);
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        this.blockUpdated = true;
    }

    @Override
    public void issueClientUpdate() {
        this.sendClientData = true;
        this.sendGraphicPacket();
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }
}

