/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import java.lang.ref.WeakReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WeakTargetRef<T extends IMultiTileEntity> {
    protected final ChunkCoordinates position = new ChunkCoordinates(0, -1, 0);
    protected final Class<?> targetClass;
    protected boolean shouldCache;
    protected WeakReference<T> target = new WeakReference<Object>(null);
    protected World world = null;

    public WeakTargetRef(Class<?> targetClass, boolean shouldCache) {
        this.targetClass = targetClass;
        this.shouldCache = shouldCache;
    }

    public WeakTargetRef(T target, boolean shouldCache) {
        this(target.getClass(), shouldCache);
        this.setTarget((Class<?>)target);
    }

    public void setTarget(T newTarget) {
        if (!this.targetClass.isInstance(newTarget)) {
            throw new IllegalArgumentException("Target is not of the correct type");
        }
        this.position.func_71571_b(newTarget.getXCoord(), (int)newTarget.getYCoord(), newTarget.getZCoord());
        this.world = newTarget.getWorld();
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setPosition(ChunkCoordinates position) {
        this.position.func_71571_b(position.field_71574_a, position.field_71572_b, position.field_71573_c);
    }

    public void setPosition(int x, int y, int z) {
        this.position.func_71571_b(x, y, z);
    }

    public void setShouldCache(boolean shouldCache) {
        this.shouldCache = shouldCache;
    }

    public T get() {
        if (!this.shouldCache) {
            return this.resolveTarget();
        }
        IMultiTileEntity result = (IMultiTileEntity)this.target.get();
        if (result == null || result.isDead()) {
            result = this.resolveTarget();
            if (result != null) {
                this.target = new WeakReference<IMultiTileEntity>(result);
            } else {
                this.target.clear();
            }
        }
        return (T)result;
    }

    protected T resolveTarget() {
        if (this.world != null && this.position.field_71574_a >= 0 && this.world.func_72899_e(this.position.field_71574_a, this.position.field_71572_b, this.position.field_71573_c)) {
            TileEntity te = this.world.func_147438_o(this.position.field_71574_a, this.position.field_71572_b, this.position.field_71573_c);
            return (T)(this.targetClass.isInstance(te) ? (IMultiTileEntity)te : null);
        }
        return null;
    }

    public ChunkCoordinates getPosition() {
        return this.position;
    }

    public void invalidate() {
        this.target.clear();
        this.world = null;
        this.position.func_71571_b(0, -1, 0);
    }
}

