/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyStorage;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.power.IPowerContainer;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTETransformer
extends MTETieredMachineBlock {
    public MTETransformer(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, 0, aDescription, new ITexture[0]);
    }

    public MTETransformer(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public MTETransformer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[12][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[2][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[3][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[4][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[5][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[6][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[7][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[8][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[9][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[10][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[11][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        return this.mTextures[Math.min(2, side.ordinal()) + (side == facingDirection ? 3 : 0) + (baseMetaTileEntity.isAllowedToWork() ? 0 : 6)][colorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETransformer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        ForgeDirection blockFrontFacing = this.getBaseMetaTileEntity().getFrontFacing();
        if (this.getBaseMetaTileEntity().isAllowedToWork()) {
            return side == blockFrontFacing;
        }
        return side != blockFrontFacing;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return !this.isInputFacing(side);
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier + 1];
    }

    @Override
    public long maxEUStore() {
        return Math.max(512L, 1L << this.mTier + 2) + GTValues.V[this.mTier + 1] * 4L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.getBaseMetaTileEntity().isAllowedToWork() ? this.mTier + 1 : this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.getBaseMetaTileEntity().isAllowedToWork() ? this.mTier : this.mTier + 1];
    }

    @Override
    public long maxAmperesOut() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 4L : 1L;
    }

    @Override
    public long maxAmperesIn() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 1L : 4L;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && GregTechAPI.mInputRF) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork());
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IPowerContainer powerContainer;
                IEnergyStorage energyStorage;
                IEnergyProvider energyProvider;
                if (aBaseMetaTileEntity.getStoredEU() >= aBaseMetaTileEntity.getEUCapacity()) break;
                if (!aBaseMetaTileEntity.inputEnergyFrom(side)) continue;
                TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(side);
                if (tTileEntity instanceof IEnergyProvider && (energyProvider = (IEnergyProvider)tTileEntity).extractEnergy(side.getOpposite(), 1, true) == 1) {
                    long tEU = ((IEnergyProvider)tTileEntity).extractEnergy(side.getOpposite(), GTUtility.safeInt(this.maxEUInput() * 100L / (long)GregTechAPI.mRFtoEU), false);
                    tEU = tEU * (long)GregTechAPI.mRFtoEU / 100L;
                    aBaseMetaTileEntity.injectEnergyUnits(ForgeDirection.UNKNOWN, Math.min(tEU, this.maxEUInput()), 1L);
                    continue;
                }
                if (tTileEntity instanceof IEnergyStorage && (energyStorage = (IEnergyStorage)tTileEntity).extractEnergy(1, true) == 1) {
                    long tEU = ((IEnergyStorage)tTileEntity).extractEnergy(GTUtility.safeInt(this.maxEUInput() * 100L / (long)GregTechAPI.mRFtoEU), false);
                    tEU = tEU * (long)GregTechAPI.mRFtoEU / 100L;
                    aBaseMetaTileEntity.injectEnergyUnits(ForgeDirection.UNKNOWN, Math.min(tEU, this.maxEUInput()), 1L);
                    continue;
                }
                if (!Mods.EnderIO.isModLoaded() || !(tTileEntity instanceof IPowerContainer) || (powerContainer = (IPowerContainer)tTileEntity).getEnergyStored() <= 0) continue;
                int storedRF = powerContainer.getEnergyStored();
                int extractRF = GTUtility.safeInt(this.maxEUInput() * 100L / (long)GregTechAPI.mRFtoEU);
                long tEU = 0L;
                if (tTileEntity instanceof TileCapBank) {
                    TileCapBank capBank = (TileCapBank)tTileEntity;
                    ICapBankNetwork network = capBank.getNetwork();
                    if (network != null && network.getEnergyStoredL() > 0L) {
                        tEU = Math.min(Math.min(Math.min(network.getEnergyStoredL(), (long)(storedRF - extractRF)), (long)network.getMaxOutput()) * (long)GregTechAPI.mRFtoEU / 100L, this.maxEUInput());
                        network.addEnergy(GTUtility.safeInt(-(tEU * 100L / (long)GregTechAPI.mRFtoEU)));
                    }
                } else if (storedRF > extractRF) {
                    powerContainer.setEnergyStored(storedRF - extractRF);
                    tEU = this.maxEUInput();
                } else {
                    powerContainer.setEnergyStored(0);
                    tEU = (long)storedRF * (long)GregTechAPI.mRFtoEU / 100L;
                }
                aBaseMetaTileEntity.injectEnergyUnits(ForgeDirection.UNKNOWN, Math.min(tEU, this.maxEUInput()), 1L);
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return true;
    }

    @Override
    public String getAlternativeModeText() {
        return (this.getBaseMetaTileEntity().isAllowedToWork() ? GTUtility.trans("145", "Step Down, In: ") : GTUtility.trans("146", "Step Up, In: ")) + this.maxEUInput() + GTUtility.trans("148", "V ") + this.maxAmperesIn() + GTUtility.trans("147", "A, Out: ") + this.maxEUOutput() + GTUtility.trans("148", "V ") + this.maxAmperesOut() + GTUtility.trans("149", "A");
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return true;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ForgeDirection facing = this.getBaseMetaTileEntity().getFrontFacing();
        NBTTagCompound tag = accessor.getNBTData();
        ForgeDirection side = accessor.getSide();
        boolean allowedToWork = tag.func_74767_n("isAllowedToWork");
        byte inputTier = GTUtility.getTier(tag.func_74763_f("maxEUInput"));
        byte outputTier = GTUtility.getTier(tag.func_74763_f("maxEUOutput"));
        currenttip.add(String.format("%s %s(%dA) -> %s(%dA)", (allowedToWork ? SpecialChars.GREEN + "Step Down" : SpecialChars.RED + "Step Up") + SpecialChars.RESET, GTMod.gregtechproxy.mWailaTransformerVoltageTier ? GTUtility.getColoredTierNameFromTier(inputTier) : Long.valueOf(tag.func_74763_f("maxEUInput")), tag.func_74763_f("maxAmperesIn"), GTMod.gregtechproxy.mWailaTransformerVoltageTier ? GTUtility.getColoredTierNameFromTier(outputTier) : Long.valueOf(tag.func_74763_f("maxEUOutput")), tag.func_74763_f("maxAmperesOut")));
        if (side == facing && allowedToWork || side != facing && !allowedToWork) {
            currenttip.add(String.format(SpecialChars.GOLD + "Input:" + SpecialChars.RESET + " %s(%dA)", GTMod.gregtechproxy.mWailaTransformerVoltageTier ? GTUtility.getColoredTierNameFromTier(inputTier) : Long.valueOf(tag.func_74763_f("maxEUInput")), tag.func_74763_f("maxAmperesIn")));
        } else {
            currenttip.add(String.format(SpecialChars.BLUE + "Output:" + SpecialChars.RESET + " %s(%dA)", GTMod.gregtechproxy.mWailaTransformerVoltageTier ? GTUtility.getColoredTierNameFromTier(outputTier) : Long.valueOf(tag.func_74763_f("maxEUOutput")), tag.func_74763_f("maxAmperesOut")));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("isAllowedToWork", this.getBaseMetaTileEntity().isAllowedToWork());
        tag.func_74772_a("maxEUInput", this.maxEUInput());
        tag.func_74772_a("maxAmperesIn", this.maxAmperesIn());
        tag.func_74772_a("maxEUOutput", this.maxEUOutput());
        tag.func_74772_a("maxAmperesOut", this.maxAmperesOut());
    }
}

