/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.forge.ListItemHandler;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.util.GTUtility;
import gregtech.api.util.item.ItemHolder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemInventoryLogic {
    private static final int DEFAULT_COLUMNS_PER_ROW = 4;
    private static final int POSITION_INTERVAL = 18;
    private static final Size SIZE = new Size(18, 18);
    protected String displayName;
    @Nonnull
    protected final IItemHandlerModifiable inventory;
    protected UUID connectedFluidInventory;
    protected int tier;
    protected boolean isUpgradeInventory;
    protected Map<ItemHolder, Long> cachedItemMap;
    protected boolean inRecipeCheck;

    public ItemInventoryLogic(int numberOfSlots) {
        this(numberOfSlots, 0);
    }

    public ItemInventoryLogic(int numberOfSlots, int tier) {
        this((IItemHandlerModifiable)new ItemStackHandler(numberOfSlots), tier, false);
    }

    public ItemInventoryLogic(int numberOfSlots, int tier, boolean isUpgradeInventory) {
        this((IItemHandlerModifiable)new ItemStackHandler(numberOfSlots), tier, isUpgradeInventory);
    }

    public ItemInventoryLogic(@Nonnull IItemHandlerModifiable inventory, int tier, boolean isUpgradeInventory) {
        this.inventory = inventory;
        this.tier = tier;
        this.isUpgradeInventory = isUpgradeInventory;
    }

    public ItemInventoryLogic(Collection<IItemHandlerModifiable> inventories) {
        this((IItemHandlerModifiable)new ListItemHandler(inventories), -1, false);
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isUpgradeInventory() {
        return this.isUpgradeInventory;
    }

    public int getSlots() {
        return this.getInventory().getSlots();
    }

    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public UUID getConnectedFluidInventoryID() {
        return this.connectedFluidInventory;
    }

    public void setConnectedFluidInventoryID(@Nullable UUID connectedFluidTank) {
        this.connectedFluidInventory = connectedFluidTank;
    }

    @Nonnull
    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList tList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tStack = this.inventory.getStackInSlot(slot);
            if (tStack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("s", (byte)slot);
            tStack.func_77955_b(tag);
            tList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("inventory", (NBTBase)tList);
        nbt.func_74768_a("tier", this.tier);
        if (this.displayName != null) {
            nbt.func_74778_a("displayName", this.displayName);
        }
        nbt.func_74757_a("isUpgradeInventory", this.isUpgradeInventory);
        if (this.connectedFluidInventory != null) {
            nbt.func_74778_a("connectedFluidInventory", this.connectedFluidInventory.toString());
        }
        return nbt;
    }

    public void loadFromNBT(@Nonnull NBTTagCompound nbt) {
        NBTTagList nbtList;
        this.tier = nbt.func_74762_e("tier");
        if (nbt.func_74764_b("displayName")) {
            this.displayName = nbt.func_74779_i("displayName");
        }
        this.isUpgradeInventory = nbt.func_74767_n("isUpgradeInventory");
        if (nbt.func_74764_b("connectedFluidInventory")) {
            this.connectedFluidInventory = UUID.fromString(nbt.func_74779_i("connectedFluidInventory"));
        }
        if ((nbtList = nbt.func_150295_c("inventory", 10)) == null) {
            return;
        }
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tNBT = nbtList.func_150305_b(i);
            short tSlot = tNBT.func_74765_d("s");
            if (tSlot < 0 || tSlot >= this.inventory.getSlots()) continue;
            this.inventory.setStackInSlot((int)tSlot, GTUtility.loadItem(tNBT));
        }
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public ItemStack[] getStoredItems() {
        ItemStack[] items = (ItemStack[])this.inventory.getStacks().stream().filter(Objects::nonNull).toArray(ItemStack[]::new);
        if (items == null) {
            return new ItemStack[0];
        }
        return items;
    }

    public boolean isStackValid(ItemStack item) {
        return true;
    }

    @Nullable
    public ItemStack insertItem(ItemStack item) {
        if (!this.isStackValid(item)) {
            return item;
        }
        for (int i = 0; i < this.inventory.getSlots() && item != null && item.field_77994_a > 0; ++i) {
            item = this.inventory.insertItem(i, item, false);
        }
        return item;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount) {
        return this.inventory.extractItem(slot, amount, false);
    }

    public boolean subtractItemAmount(@Nonnull ItemHolder item, long amount, boolean simulate) {
        Map<ItemHolder, Long> itemMap = this.getMapOfStoredItems();
        if (!itemMap.containsKey(item)) {
            return false;
        }
        if (itemMap.get(item) < amount) {
            return false;
        }
        if (simulate) {
            return true;
        }
        itemMap.put(item, itemMap.get(item) - amount);
        return true;
    }

    @Nullable
    public ItemStack getItemInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public void sort() {
        Map<ItemHolder, Long> itemMap = this.getMapOfStoredItems();
        List<ItemHolder> sortedItems = itemMap.keySet().stream().sorted(Comparator.comparing(a -> a.getItem().func_77658_a() + a.getMeta())).collect(Collectors.toList());
        this.putInItemsFromMap(itemMap, sortedItems);
    }

    public void update(boolean shouldSort) {
        if (shouldSort) {
            this.sort();
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack item = this.inventory.getStackInSlot(i);
            if (item == null || item.field_77994_a > 0) continue;
            this.inventory.setStackInSlot(i, null);
        }
    }

    @Nonnull
    public Widget getGuiPart() {
        return this.getGUIPart(4);
    }

    @Nonnull
    public Widget getGUIPart(int columnsPerRow) {
        Scrollable scrollable = new Scrollable();
        scrollable.setVerticalScroll();
        int rows = 0;
        while (rows * columnsPerRow < Math.min(this.inventory.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(this.inventory.getSlots(), 128) - rows * columnsPerRow, columnsPerRow);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(this.inventory, rows * columnsPerRow + column).setPos(column * 18, rows * 18).setSize(SIZE));
            }
            ++rows;
        }
        return scrollable;
    }

    public void startRecipeCheck() {
        this.cachedItemMap = this.getMapOfStoredItems();
        this.inRecipeCheck = true;
    }

    public void stopRecipeCheck() {
        this.inRecipeCheck = false;
        this.putInItemsFromMap(this.cachedItemMap, null);
        this.cachedItemMap = null;
    }

    @Nonnull
    public Map<ItemHolder, Long> getMapOfStoredItems() {
        if (this.inRecipeCheck) {
            return this.cachedItemMap;
        }
        HashMap<ItemHolder, Long> items = new HashMap<ItemHolder, Long>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack item = this.extractItem(i, Integer.MAX_VALUE);
            if (item == null) continue;
            ItemHolder itemHolder = new ItemHolder(item);
            items.put(itemHolder, items.getOrDefault(itemHolder, 0L) + (long)item.field_77994_a);
        }
        return items;
    }

    protected void putInItemsFromMap(@Nonnull Map<ItemHolder, Long> itemMap, @Nullable List<ItemHolder> sortedList) {
        for (ItemHolder itemHolder : sortedList == null ? itemMap.keySet() : sortedList) {
            ItemStack item = new ItemStack(itemHolder.getItem(), 0, itemHolder.getMeta());
            item.func_77982_d(itemHolder.getNBT());
            for (long itemAmount = itemMap.get(itemHolder).longValue(); itemAmount > 0L; itemAmount -= (long)item.field_77994_a) {
                item.field_77994_a = (int)Math.min((long)item.func_77976_d(), itemAmount);
                this.insertItem(item);
            }
        }
    }

    public long calculateAmountOfTimesItemCanBeTaken(ItemHolder item, long amount) {
        return this.getMapOfStoredItems().getOrDefault(item, 0L) / amount;
    }

    public Set<ItemHolder> getSetOfStoredItems() {
        return this.getMapOfStoredItems().keySet();
    }
}

