/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import com.gtnewhorizons.modularui.api.fluids.FluidTanksHandler;
import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import com.gtnewhorizons.modularui.api.fluids.ListFluidHandler;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidInventoryLogic {
    private static final int DEFAULT_COLUMNS_PER_ROW = 4;
    private static final int POSITION_INTERVAL = 18;
    private static final Size SIZE = new Size(18, 18);
    protected String displayName = "";
    @Nonnull
    protected final IFluidTanksHandler inventory;
    protected final Map<Fluid, IFluidTankLong> fluidToTankMap;
    protected int tier = 0;
    protected boolean isUpgradeInventory = false;

    public FluidInventoryLogic(int numberOfSlots, long capacityOfEachTank) {
        this((IFluidTanksHandler)new FluidTanksHandler(numberOfSlots, capacityOfEachTank), 0, false);
    }

    public FluidInventoryLogic(int numberOfSlots, long capacityOfEachTank, int tier) {
        this((IFluidTanksHandler)new FluidTanksHandler(numberOfSlots, capacityOfEachTank), tier, false);
    }

    public FluidInventoryLogic(int numberOfSlots, long capacityOfEachTank, int tier, boolean isUpgradeInventory) {
        this((IFluidTanksHandler)new FluidTanksHandler(numberOfSlots, capacityOfEachTank), tier, isUpgradeInventory);
    }

    public FluidInventoryLogic(@Nonnull IFluidTanksHandler inventory, int tier, boolean isUpgradeInventory) {
        this.inventory = inventory;
        this.fluidToTankMap = new HashMap<Fluid, IFluidTankLong>(inventory.getTanks());
        this.tier = tier;
        this.isUpgradeInventory = isUpgradeInventory;
    }

    public FluidInventoryLogic(Collection<IFluidTanksHandler> inventories) {
        this((IFluidTanksHandler)new ListFluidHandler(inventories), -1, false);
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isUpgradeInventory() {
        return this.isUpgradeInventory;
    }

    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    @Nonnull
    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList tList = new NBTTagList();
        for (int tankNumber = 0; tankNumber < this.inventory.getTanks(); ++tankNumber) {
            IFluidTankLong tank = this.inventory.getFluidTank(tankNumber);
            if (tank == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("s", (byte)tankNumber);
            tank.saveToNBT(tag);
            tList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("inventory", (NBTBase)tList);
        nbt.func_74768_a("tier", this.tier);
        if (this.displayName != null) {
            nbt.func_74778_a("displayName", this.displayName);
        }
        nbt.func_74757_a("isUpgradeInventory", this.isUpgradeInventory);
        return nbt;
    }

    public void loadFromNBT(@Nonnull NBTTagCompound nbt) {
        NBTTagList nbtList = nbt.func_150295_c("inventory", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tankNBT = nbtList.func_150305_b(i);
            short tank = tankNBT.func_74765_d("s");
            if (tank >= 0 && tank < this.inventory.getTanks()) {
                this.inventory.getFluidTank((int)tank).loadFromNBT(tankNBT);
            }
            if (this.inventory.getFluidInTank((int)tank) == null) continue;
            this.fluidToTankMap.put(this.inventory.getFluidInTank((int)tank), this.inventory.getFluidTank((int)tank));
        }
        this.tier = nbt.func_74762_e("tier");
        if (nbt.func_74764_b("displayName")) {
            this.displayName = nbt.func_74779_i("displayName");
        }
        this.isUpgradeInventory = nbt.func_74767_n("isUpgradeInventory");
    }

    @Nonnull
    public IFluidTanksHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public FluidStack[] getStoredFluids() {
        FluidStack[] fluids = (FluidStack[])this.inventory.getFluids().stream().filter(Objects::nonNull).toArray(FluidStack[]::new);
        if (fluids == null) {
            return new FluidStack[0];
        }
        return fluids;
    }

    public boolean isFluidValid(@Nullable Fluid fluid) {
        return fluid != null;
    }

    public long fill(@Nullable Fluid fluid, long amount, boolean simulate) {
        if (!this.isFluidValid(fluid)) {
            return 0L;
        }
        IFluidTankLong tank = this.fluidToTankMap.get(fluid);
        if (tank != null) {
            return tank.fill(fluid, amount, !simulate);
        }
        int tankNumber = 0;
        tank = this.inventory.getFluidTank(tankNumber++);
        while (tank.getStoredFluid() != fluid && tank.getStoredFluid() != null) {
            tank = this.inventory.getFluidTank(tankNumber++);
        }
        this.fluidToTankMap.put(fluid, tank);
        return tank.fill(fluid, amount, !simulate);
    }

    @Nullable
    public FluidStack fill(@Nullable FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        for (int i = 0; i < this.inventory.getTanks(); ++i) {
            this.fill(fluid.getFluid(), fluid.amount, false);
        }
        return fluid;
    }

    @Nullable
    public FluidStack drain(long amount, boolean simulate) {
        for (int i = 0; i < this.inventory.getTanks(); ++i) {
            Fluid fluid = this.inventory.getFluidInTank(i);
            FluidStack drained = this.drain(fluid, amount, simulate);
            if (drained == null) continue;
            return drained;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(Fluid fluid, long amount, boolean simulate) {
        if (!this.isFluidValid(fluid)) {
            return null;
        }
        IFluidTankLong tank = this.fluidToTankMap.get(fluid);
        if (tank != null) {
            return tank.drain(amount, !simulate);
        }
        int tankNumber = 0;
        tank = this.inventory.getFluidTank(tankNumber++);
        while (tank.getStoredFluid() != fluid) {
            tank = this.inventory.getFluidTank(tankNumber++);
        }
        this.fluidToTankMap.put(fluid, tank);
        return tank.drain(amount, !simulate);
    }

    public void update() {
        for (int i = 0; i < this.inventory.getTanks(); ++i) {
            IFluidTankLong tank = this.inventory.getFluidTank(i);
            if (tank.getFluidAmountLong() > 0L) continue;
            tank.setFluid(null, 0L);
        }
    }

    public long calculateAmountOfTimesFluidCanBeTaken(Fluid fluid, long amountToTake) {
        if (!this.isFluidValid(fluid)) {
            return 0L;
        }
        IFluidTankLong tank = this.fluidToTankMap.get(fluid);
        if (tank == null) {
            return 0L;
        }
        return tank.getFluidAmountLong() / amountToTake;
    }

    @Nonnull
    public Map<Fluid, Long> getMapOfStoredFluids() {
        HashMap<Fluid, Long> map = new HashMap<Fluid, Long>();
        for (int i = 0; i < this.inventory.getTanks(); ++i) {
            Fluid fluid;
            IFluidTankLong tank = this.inventory.getFluidTank(i);
            if (tank == null || (fluid = tank.getStoredFluid()) == null) continue;
            map.put(fluid, map.getOrDefault(fluid, 0L) + tank.getFluidAmountLong());
        }
        return map;
    }

    @Nonnull
    public Widget getGuiPart() {
        return this.getGUIPart(4);
    }

    @Nonnull
    public Widget getGUIPart(int columnsPerRow) {
        Scrollable scrollable = new Scrollable();
        scrollable.setVerticalScroll();
        int rows = 0;
        while (rows * 4 < this.inventory.getTanks()) {
            int columnsToMake = Math.min(this.inventory.getTanks() - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget(this.inventory, rows * 4 + column);
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(SIZE));
            }
            ++rows;
        }
        return scrollable;
    }
}

