/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.gui.GUIHost;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class GUIProvider<T extends GUIHost> {
    @Nonnull
    protected final T host;

    public GUIProvider(@Nonnull T host) {
        this.host = host;
    }

    @Nonnull
    public ModularWindow openGUI(@Nonnull UIBuildContext uiContext) {
        ModularWindow.Builder builder = Objects.requireNonNull(ModularWindow.builder((int)this.host.getWidth(), (int)this.host.getHeight()));
        if (this.shouldBindPlayerInventory()) {
            builder.bindPlayerInventory(uiContext.getPlayer());
        }
        this.attachSynchHandlers(builder, uiContext);
        this.addWidgets(builder, uiContext);
        return Objects.requireNonNull(builder.build());
    }

    protected abstract void attachSynchHandlers(@Nonnull ModularWindow.Builder var1, @Nonnull UIBuildContext var2);

    protected abstract void addWidgets(@Nonnull ModularWindow.Builder var1, @Nonnull UIBuildContext var2);

    protected boolean shouldBindPlayerInventory() {
        return true;
    }
}

