/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.GTValues;
import javax.annotation.Nonnull;
import net.minecraft.util.StatCollector;

public enum HeatingCoilLevel {
    None,
    ULV,
    LV,
    MV,
    HV,
    EV,
    IV,
    LuV,
    ZPM,
    UV,
    UHV,
    UEV,
    UIV,
    UMV,
    UXV,
    MAX;

    private static final HeatingCoilLevel[] VALUES;

    public long getHeat() {
        return this == None ? 0L : 1L + 900L * (long)this.ordinal();
    }

    public byte getTier() {
        return (byte)(this.ordinal() - 2);
    }

    public byte getLevel() {
        return (byte)(1 << Math.min(Math.max(0, this.ordinal() - 2), 4));
    }

    public int getCostDiscount() {
        return 1 << Math.max(0, this.ordinal() - 5);
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("GT5U.coil." + (Object)((Object)this)));
    }

    @Nonnull
    public static HeatingCoilLevel getFromTier(byte tier) {
        if (tier < 0 || tier > HeatingCoilLevel.getMaxTier()) {
            return None;
        }
        return VALUES[tier + 2];
    }

    @Nonnull
    public static String getDisplayNameFromHeat(int heat, boolean applyColor) {
        for (HeatingCoilLevel heatLevel : VALUES) {
            if (heatLevel == None || heatLevel == ULV || heatLevel.getHeat() < (long)heat) continue;
            String name = heatLevel.getName();
            if (applyColor) {
                name = GTValues.TIER_COLORS[heatLevel.getTier() + 1] + name;
            }
            return name;
        }
        String name = MAX.getName() + "+";
        if (applyColor) {
            name = GTValues.TIER_COLORS[MAX.getTier() + 1] + name;
        }
        return name;
    }

    public static int size() {
        return VALUES.length;
    }

    public static int getMaxTier() {
        return VALUES.length - 1 - 2;
    }

    static {
        VALUES = HeatingCoilLevel.values();
    }
}

