/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.util;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTEFrame;
import gregtech.api.util.GTOreDictUnificator;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class StructureHelper {
    public static <T> IStructureElement<T> addFrame(final Materials aMaterials) {
        return new IStructureElement<T>(){
            private IIcon[] mIcons;

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tBlock = world.func_147438_o(x, y, z);
                if (tBlock instanceof BaseMetaPipeEntity) {
                    BaseMetaPipeEntity tFrame = (BaseMetaPipeEntity)tBlock;
                    if (tFrame.isInvalidTileEntity()) {
                        return false;
                    }
                    if (tFrame.getMetaTileEntity() instanceof MTEFrame) {
                        return ((MTEFrame)tFrame.getMetaTileEntity()).mMaterial == aMaterials;
                    }
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, aMaterials.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex].getIcon());
                }
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])aMaterials.mRGBa);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                ItemStack tFrame = GTOreDictUnificator.get(OrePrefixes.frameGt, aMaterials, 1L);
                Item item = tFrame.func_77973_b();
                if (item instanceof ItemBlock) {
                    ItemBlock tFrameStackItem = (ItemBlock)item;
                    return tFrameStackItem.placeBlockAt(tFrame, null, world, x, y, z, 6, 0.0f, 0.0f, 0.0f, Items.field_151008_G.getDamage(tFrame));
                }
                return false;
            }
        };
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheFuckingMeta, Function<T, Integer> aGetTheFuckingMeta, int maxMeta) {
        return StructureHelper.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheFuckingMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheFuckingMeta, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(final Block aBlock, final BiPredicate<T, Integer> aSetTheFuckingMeta, final Function<T, Integer> aGetTheFuckingMeta, final int maxMeta) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block tBlock = world.func_147439_a(x, y, z);
                if (aBlock == tBlock) {
                    Integer currentMeta = (Integer)aGetTheFuckingMeta.apply(t);
                    int newMeta = tBlock.func_149643_k(world, x, y, z) + 1;
                    if (newMeta > maxMeta) {
                        return false;
                    }
                    if (currentMeta == 0) {
                        return aSetTheFuckingMeta.test(t, newMeta);
                    }
                    return currentMeta == newMeta;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aBlock, (int)this.getMeta(trigger));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, aBlock, this.getMeta(trigger), 3);
            }

            private int getMeta(ItemStack trigger) {
                int meta = trigger.field_77994_a - 1;
                if (meta <= 0) {
                    meta = 0;
                }
                if (meta >= maxMeta) {
                    meta = maxMeta - 1;
                }
                return meta;
            }
        };
    }
}

