/*
 * Decompiled with CFR 0.152.
 */
package ggfab.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GGMetaItemDumbItems
extends MetaBaseItem {
    public static final int MAX_ID = 32766;
    private final BitSet mEnabledItems = new BitSet();
    private final BitSet mVisibleItems = new BitSet();
    private final ArrayList<IIcon> mIconList = new ArrayList();
    private final TIntObjectMap<IItemContainer> mIconOverride = new TIntObjectHashMap();

    public GGMetaItemDumbItems(String aUnlocalized) {
        super(aUnlocalized);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aID < 0 || aID > 32766) {
            return null;
        }
        if (aToolTip == null) {
            aToolTip = "";
        }
        ItemStack rStack = new ItemStack((Item)this, 1, aID);
        this.mEnabledItems.set(aID);
        this.mVisibleItems.set(aID);
        GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".name", aEnglish);
        GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".tooltip", aToolTip);
        ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
        for (Object tRandomData : aRandomData) {
            if (!(tRandomData instanceof SubTag)) continue;
            if (tRandomData == SubTag.INVISIBLE) {
                this.mVisibleItems.set(aID, false);
                continue;
            }
            if (tRandomData != SubTag.NO_UNIFICATION) continue;
            GTOreDictUnificator.addToBlacklist(rStack);
        }
        for (Object tRandomData : aRandomData) {
            if (tRandomData == null) continue;
            boolean tUseOreDict = true;
            if (tRandomData instanceof IItemBehaviour) {
                IItemBehaviour behavior = (IItemBehaviour)tRandomData;
                this.addItemBehavior(aID, behavior);
                tUseOreDict = false;
            }
            if (tRandomData instanceof IItemContainer) {
                ((IItemContainer)tRandomData).set(rStack);
                tUseOreDict = false;
            }
            if (tRandomData instanceof SubTag) continue;
            if (tRandomData instanceof IItemContainer) {
                this.mIconOverride.put(aID, (Object)((IItemContainer)tRandomData));
                continue;
            }
            if (tRandomData instanceof TCAspects.TC_AspectStack) {
                ((TCAspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                continue;
            }
            if (tRandomData instanceof ItemData) {
                if (GTUtility.isStringValid(tRandomData)) {
                    GTOreDictUnificator.registerOre(tRandomData, rStack);
                    continue;
                }
                GTOreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                continue;
            }
            if (!tUseOreDict) continue;
            GTOreDictUnificator.registerOre(tRandomData, rStack);
        }
        if (GregTechAPI.sThaumcraftCompat != null) {
            GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
        }
        return rStack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        this.mIconList.clear();
        this.mIconList.ensureCapacity(j);
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (this.mEnabledItems.get(i)) {
                this.mIconList.add(aIconRegister.func_94245_a("ggfab:" + this.func_77658_a() + "/" + i));
                continue;
            }
            this.mIconList.add(null);
        }
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0 || aMetaData >= this.mIconList.size() || this.mIconList.get(aMetaData) == null) {
            return super.func_77617_a(aMetaData);
        }
        return this.mIconList.get(aMetaData);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            if (!this.mVisibleItems.get(i) && (!GTValues.D1 || !this.mEnabledItems.get(i))) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    public Long[] getElectricStats(ItemStack aStack) {
        return null;
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }
}

