/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.dynconfig;

import galacticgreg.GalacticGreg;
import galacticgreg.api.Enums;
import galacticgreg.api.ModContainer;
import galacticgreg.api.ModDimensionDef;
import galacticgreg.api.enums.properties.Asteroids;
import galacticgreg.registry.GalacticGregRegistry;
import java.util.HashMap;
import java.util.Map;

public class DynamicDimensionConfig {
    private static final Map<String, AsteroidConfig> _mDynamicAsteroidMap = new HashMap<String, AsteroidConfig>();

    public static AsteroidConfig getAsteroidConfig(ModDimensionDef pDimDef) {
        return _mDynamicAsteroidMap.getOrDefault(pDimDef.getDimIdentifier(), null);
    }

    public static boolean InitDynamicConfig() {
        try {
            Asteroids[] ASTEROIDS_VALUES = Asteroids.values();
            for (ModContainer mc : GalacticGregRegistry.getModContainers()) {
                if (!mc.isModLoaded()) continue;
                for (ModDimensionDef mdd : mc.getDimensionList()) {
                    Enums.DimensionType dt = mdd.getDimensionType();
                    if (dt != Enums.DimensionType.Asteroid) continue;
                    String tDimIdentifier = mdd.getDimIdentifier();
                    if (_mDynamicAsteroidMap.containsKey(tDimIdentifier)) {
                        GalacticGreg.Logger.warn("Found 2 Dimensions with the same Identifier! This should never happen, and you should report this to me. Identifier in question: %s", tDimIdentifier);
                        continue;
                    }
                    Asteroids AsteroidProperties = null;
                    for (Asteroids asteroidsConfig : ASTEROIDS_VALUES) {
                        if (!asteroidsConfig.modContainers.modContainer.getModName().equals(mc.getModName()) || !asteroidsConfig.dimensionDef.modDimensionDef.getDimensionName().equals(mdd.getDimensionName())) continue;
                        AsteroidProperties = asteroidsConfig;
                        break;
                    }
                    if (AsteroidProperties == null) {
                        GalacticGreg.Logger.error("Something went wrong! no properties are existing for Asteroid dim: " + mdd.getDimensionName() + " from mod container " + mc.getModName(), new Object[0]);
                        continue;
                    }
                    AsteroidConfig aConf = new AsteroidConfig();
                    aConf.MinSize = AsteroidProperties.asteroidPropertyBuilder.sizeMin;
                    aConf.MaxSize = AsteroidProperties.asteroidPropertyBuilder.sizeMax;
                    aConf.Probability = AsteroidProperties.asteroidPropertyBuilder.probability;
                    aConf.SpecialBlockChance = AsteroidProperties.asteroidPropertyBuilder.specialBlockChance;
                    aConf.OreChance = AsteroidProperties.asteroidPropertyBuilder.oreSpawn.baseOreChance;
                    aConf.OrePrimaryOffset = AsteroidProperties.asteroidPropertyBuilder.oreSpawn.primaryToRareOreOffset;
                    aConf.SmallOreChance = AsteroidProperties.asteroidPropertyBuilder.oreSpawn.smallOreChance;
                    aConf.ObeyHeightLimits = AsteroidProperties.asteroidPropertyBuilder.oreSpawn.obeyHeighLimits;
                    aConf.HiddenOres = AsteroidProperties.asteroidPropertyBuilder.oreSpawn.oresOnlyInsideAsteroids;
                    if (GalacticGreg.GalacticConfig.LootChestsEnabled) {
                        aConf.LootChestChance = AsteroidProperties.asteroidPropertyBuilder.loot.lootChestChance;
                        aConf.LootChestTable = AsteroidProperties.asteroidPropertyBuilder.loot.lootChestTable;
                        aConf.NumLootItems = AsteroidProperties.asteroidPropertyBuilder.loot.lootChestItemCount;
                        aConf.RandomizeNumLootItems = AsteroidProperties.asteroidPropertyBuilder.loot.randomizeLootItemCount;
                    } else {
                        aConf.LootChestChance = 0;
                        aConf.LootChestTable = 1;
                        aConf.NumLootItems = 0;
                        aConf.RandomizeNumLootItems = false;
                    }
                    if (aConf.MaxSize > 50) {
                        GalacticGreg.Logger.warn("Asteroid-MaxSize for dimID [%s] is larger than 50. This might cause memory-problems, as the maximum asteroid size will be larger than 50*50*50 blocks", tDimIdentifier);
                    }
                    _mDynamicAsteroidMap.put(tDimIdentifier, aConf);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getLootChestTable(AsteroidConfig pACfg) {
        String tLootTable = "mineshaftCorridor";
        switch (pACfg.LootChestTable) {
            case 2: {
                tLootTable = "pyramidDesertyChest";
                break;
            }
            case 3: {
                tLootTable = "pyramidJungleChest";
                break;
            }
            case 4: {
                tLootTable = "pyramidJungleDispenser";
                break;
            }
            case 5: {
                tLootTable = "strongholdCorridor";
                break;
            }
            case 6: {
                tLootTable = "strongholdLibrary";
                break;
            }
            case 7: {
                tLootTable = "strongholdCrossing";
                break;
            }
            case 8: {
                tLootTable = "villageBlacksmith";
                break;
            }
            case 9: {
                tLootTable = "bonusChest";
                break;
            }
            case 10: {
                tLootTable = "dungeonChest";
            }
        }
        return tLootTable;
    }

    public static class AsteroidConfig {
        public int MinSize;
        public int MaxSize;
        public int Probability;
        public int OreChance;
        public int OrePrimaryOffset;
        public int SpecialBlockChance;
        public int SmallOreChance;
        public boolean ObeyHeightLimits;
        public boolean HiddenOres;
        public int LootChestChance;
        public int LootChestTable;
        public int NumLootItems;
        public boolean RandomizeNumLootItems;
    }
}

