/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util.NoiseUtil;

import bartworks.API.INoiseGen;
import bartworks.util.MathUtils;
import bartworks.util.NoiseUtil.SimplexNoise;
import gregtech.api.objects.XSTR;
import java.util.Random;

public class BartsNoise
implements INoiseGen {
    boolean usePhase;
    int octaves;
    double frequency;
    double amplitude;
    long seed;
    Random random;

    public void setUsePhase(boolean usePhase) {
        this.usePhase = usePhase;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public BartsNoise(int octaves, double frequency, double amplitude, long seed) {
        this.octaves = octaves;
        this.frequency = frequency;
        this.amplitude = amplitude;
        this.seed = seed;
        this.random = new XSTR(seed);
    }

    public BartsNoise() {
        this.seed = new XSTR().nextLong();
        this.random = new XSTR(this.seed);
        this.octaves = 1;
        this.frequency = this.random.nextGaussian();
        this.amplitude = this.random.nextGaussian();
    }

    public BartsNoise(long seed) {
        this.seed = seed;
        this.random = new XSTR(seed);
        this.octaves = 1;
        this.frequency = this.random.nextGaussian();
        this.amplitude = this.random.nextGaussian();
    }

    public BartsNoise copy() {
        return new BartsNoise(this.octaves, this.frequency, this.amplitude, this.seed);
    }

    public BartsNoise copy(long seed) {
        return new BartsNoise(this.octaves, this.frequency, this.amplitude, seed);
    }

    public double getCosNoise(double x, double y) {
        double result2;
        double pr = x * this.frequency;
        double r1 = Math.cos(pr);
        if (r1 < 0.0) {
            r1 = Math.abs(r1);
        }
        double result = Math.pow(r1, this.amplitude);
        double pr2 = y * this.frequency;
        double r2 = Math.cos(pr2);
        if (r2 < 0.0) {
            r2 = Math.abs(r2);
        }
        if ((result *= (result2 = Math.pow(r2, this.amplitude))) == Double.POSITIVE_INFINITY) {
            result = Double.MAX_VALUE;
        }
        if (result == Double.NEGATIVE_INFINITY) {
            result = Double.MIN_VALUE;
        }
        return MathUtils.wrap(result, 1.0);
    }

    double getNonOctavedNoise(double x, double y) {
        double phase = SimplexNoise.noise(Math.pow(x * this.frequency, this.amplitude), Math.pow(y * this.frequency, this.amplitude));
        return MathUtils.wrap(phase, 1.0);
    }

    public double getNeighbouringNoise(int x, int y) {
        return (this.getNoiseSingle(x - 1, y - 1) + this.getNoiseSingle(x, y - 1) + this.getNoiseSingle(x - 1, y) + this.getNoiseSingle(x + 1, y) + this.getNoiseSingle(x, y + 1) + this.getNoiseSingle(x + 1, y + 1) + this.getNoiseSingle(x - 1, y + 1) + this.getNoiseSingle(x + 1, y - 1)) / 8.0;
    }

    public double getNoiseSingle(int x, int y) {
        double result = 0.0;
        for (double i = 1.0; i <= (double)this.octaves; i += 1.0) {
            result += 1.0 / i * this.getNonOctavedNoise(i * (double)x, i * (double)y);
        }
        return result;
    }

    @Override
    public double getNoise(int x, int y) {
        double result = 0.0;
        for (double i = 1.0; i <= (double)this.octaves; i += 1.0) {
            result += 1.0 / i * this.getNonOctavedNoise(i * (double)x, y);
        }
        return MathUtils.wrap(result, 1.0);
    }

    @Override
    public double[][] getNoiseForRegion(int xStart, int zStart, int xEnd, int zEnd) {
        return new double[0][0];
    }

    @Override
    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    @Override
    public void setOctaves(int octaves) {
        this.octaves = octaves;
    }

    @Override
    public void setFrequency(double freq) {
        this.frequency = freq;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    public static enum NoiseColor {
        Red(-1.0),
        Pink(-0.5),
        White(0.0),
        Blue(0.5),
        Violet(1.0);

        double ampl;

        private NoiseColor(double num) {
            this.ampl = num;
        }

        public BartsNoise getColoredNoise() {
            BartsNoise noise = new BartsNoise();
            noise.setAmplitude(this.ampl);
            return noise;
        }
    }
}

