/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.textures;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.client.textures.BaseTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.common.entities.golems.EnumGolemType;

public class GolemGuiTexture
extends BaseTexture {
    private static final Logger LOGGER = LogManager.getLogger();

    public int func_110552_b() {
        return super.func_110552_b();
    }

    public GolemGuiTexture(ResourceLocation textureLocation) {
        super(textureLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (InputStream inputstream = null;){
            IResource iresource = resourceManager.func_110536_a(this.field_110568_b);
            inputstream = iresource.func_110527_b();
            BufferedImage bufferedimage = this.manipulateImage(resourceManager, ImageIO.read(inputstream));
            boolean flag = false;
            boolean flag1 = false;
            if (iresource.func_110528_c()) {
                try {
                    TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                    if (texturemetadatasection != null) {
                        flag = texturemetadatasection.func_110479_a();
                        flag1 = texturemetadatasection.func_110480_b();
                    }
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Failed reading metadata of: " + this.field_110568_b, (Throwable)runtimeexception);
                }
            }
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)bufferedimage, (boolean)flag, (boolean)flag1);
        }
    }

    private BufferedImage manipulateImage(IResourceManager resourceManager, BufferedImage image) throws IOException {
        int scale = image.getWidth() / 256;
        List<AdditionalGolemType> types = GadomancyApi.getAdditionalGolemTypes();
        int newHeight = 24 * scale * (this.getMaxOrdinal() + 1);
        BufferedImage newImg = new BufferedImage(image.getWidth(), newHeight < image.getHeight() ? image.getHeight() : newHeight, image.getType());
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                newImg.setRGB(x, y, image.getRGB(x, y));
            }
        }
        for (AdditionalGolemType type : types) {
            try {
                int ordinal = type.getEnumEntry().ordinal();
                BufferedImage slotImg = this.loadImage(resourceManager, type.getInvSlotTexture());
                float slotScale = (float)(24 * scale) / (float)slotImg.getWidth();
                if (slotScale > 1.0f) {
                    slotImg = this.scaleImage(slotImg, slotScale, slotScale);
                }
                for (int x = 0; x < slotImg.getWidth(); ++x) {
                    for (int y = 0; y < slotImg.getHeight(); ++y) {
                        newImg.setRGB(184 * scale + x, ordinal * (24 * scale) + y, slotImg.getRGB(x, y));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed loading golem inventory slot texture of: " + type.getModId() + ":" + type.getName());
            }
        }
        return newImg;
    }

    private BufferedImage scaleImage(BufferedImage input, float xScale, float yScale) {
        int newX = (int)((float)input.getWidth() * xScale);
        int newY = (int)((float)input.getHeight() * yScale);
        Image temp = input.getScaledInstance(newX, newY, 8);
        BufferedImage img = new BufferedImage(newX, newY, input.getType());
        Graphics2D graphics = img.createGraphics();
        graphics.drawImage(temp, 0, 0, null);
        graphics.dispose();
        return img;
    }

    private int getMaxOrdinal() {
        int max = 0;
        for (EnumGolemType type : EnumGolemType.values()) {
            if (type.ordinal() <= max) continue;
            max = type.ordinal();
        }
        return max;
    }
}

