/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.fx;

import com.gtnh.findit.fx.FxHelper;
import com.gtnh.findit.util.ClientFinderHelperUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class BlockHighlighter {
    private List<ChunkPosition> positions = new ArrayList<ChunkPosition>();
    private long expireHighlight;

    public void highlightBlocks(List<ChunkPosition> positions, long expireHighlight) {
        this.positions = positions;
        this.expireHighlight = expireHighlight;
    }

    public void renderHighlightedBlock(RenderWorldLastEvent event) {
        if (this.positions.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        if (time > this.expireHighlight) {
            this.positions.clear();
        }
        EntityClientPlayerMP p = mc.field_71439_g;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)event.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)event.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glLineWidth((float)3.0f);
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (ChunkPosition pos : this.positions) {
            BlockHighlighter.drawBlockHighlightBox(mc.field_71441_e, pos);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static void drawBlockHighlightBox(WorldClient world, ChunkPosition pos) {
        Block block = world.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        AxisAlignedBB box = block instanceof BlockChest ? BlockHighlighter.getChestHighlightBox(world, (BlockChest)block, pos) : BlockHighlighter.getBlockHighlightBox(world, block, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        FxHelper.renderBoxOutline(box);
    }

    private static AxisAlignedBB getChestHighlightBox(WorldClient world, BlockChest block, ChunkPosition pos) {
        AxisAlignedBB chestBox = BlockHighlighter.getBlockHighlightBox(world, (Block)block, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        TileEntity tileEntity = world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        if (!(tileEntity instanceof TileEntityChest)) {
            return chestBox;
        }
        TileEntityChest chest = (TileEntityChest)tileEntity;
        TileEntityChest nearChest = null;
        if (chest.field_145991_k != null) {
            nearChest = chest.field_145991_k;
        } else if (chest.field_145990_j != null) {
            nearChest = chest.field_145990_j;
        } else if (chest.field_145992_i != null) {
            nearChest = chest.field_145992_i;
        } else if (chest.field_145988_l != null) {
            nearChest = chest.field_145988_l;
        }
        if (nearChest == null) {
            return chestBox;
        }
        AxisAlignedBB nearChestBox = BlockHighlighter.getBlockHighlightBox(world, nearChest.func_145838_q(), nearChest.field_145851_c, nearChest.field_145848_d, nearChest.field_145849_e);
        return ClientFinderHelperUtils.mergeAABB(chestBox, nearChestBox);
    }

    private static AxisAlignedBB getBlockHighlightBox(WorldClient world, Block block, int x, int y, int z) {
        block.func_149719_a((IBlockAccess)world, x, y, z);
        AxisAlignedBB box = block.func_149633_g((World)world, x, y, z);
        if (box.field_72336_d - box.field_72340_a < 0.25 || box.field_72337_e - box.field_72338_b < 0.25 || box.field_72334_f - box.field_72339_c < 0.25) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        return box;
    }
}

