/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit;

import com.gtnh.findit.service.itemfinder.FindItemRequest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

@FunctionalInterface
public interface IStackFilter {
    public boolean matches(FindItemRequest var1);

    public static class AnyMultiItemFilter
    implements IStackFilter {
        private final List<IStackFilter> filters;

        public AnyMultiItemFilter(List<IStackFilter> filters) {
            this.filters = filters;
        }

        public AnyMultiItemFilter() {
            this(new ArrayList<IStackFilter>());
        }

        public void add(IStackFilter filter) {
            if (filter != null) {
                this.filters.add(filter);
            }
        }

        public boolean isEmpty() {
            return this.filters.isEmpty();
        }

        @Override
        public boolean matches(FindItemRequest request) {
            for (IStackFilter filter : this.filters) {
                if (filter == null || !filter.matches(request)) continue;
                return true;
            }
            return false;
        }
    }

    public static class FluidStackFilter
    implements IStackFilter {
        private final List<FluidStack> fluids;

        public FluidStackFilter(List<FluidStack> fluids) {
            this.fluids = fluids;
        }

        public FluidStackFilter() {
            this(new ArrayList<FluidStack>());
        }

        public FluidStackFilter(FluidStack fluid) {
            this();
            this.add(fluid);
        }

        public void add(FluidStack fluid) {
            if (fluid != null) {
                this.fluids.add(fluid);
            }
        }

        public boolean isEmpty() {
            return this.fluids.isEmpty();
        }

        @Override
        public boolean matches(FindItemRequest request) {
            for (FluidStack fluid : this.fluids) {
                if (fluid == null || !request.isFluidSatisfies(fluid)) continue;
                return true;
            }
            return false;
        }
    }

    public static class InventoryStackFilter
    implements IStackFilter {
        private final IInventory inventory;
        private final EntityPlayer player;

        public InventoryStackFilter(EntityPlayer player, IInventory inventory) {
            this.inventory = inventory;
            this.player = player;
        }

        @Override
        public boolean matches(FindItemRequest request) {
            for (int slot = 0; slot < this.inventory.func_70302_i_(); ++slot) {
                ItemStack slotItem = this.inventory.func_70301_a(slot);
                if (slotItem == null || !request.isStackSatisfies(this.player, slotItem)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface IStackFilterProvider {
        public IStackFilter getFilter(EntityPlayer var1, TileEntity var2);

        public IStackFilter getFilter(EntityPlayer var1, ItemStack var2);
    }
}

