/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.render;

import com.caedis.duradisplay.render.OverlayRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class VerticalBarRenderer
extends OverlayRenderer {
    private final int color;
    private final double durabilityPercent;
    private final boolean smoothBar;
    private final int offset;
    private final boolean showBackground;
    private static final Tessellator tessellator = Tessellator.field_78398_a;

    public VerticalBarRenderer(int color, double durabilityPercent, boolean smoothBar, int offset, boolean showBackground) {
        this.color = color;
        this.durabilityPercent = durabilityPercent;
        this.smoothBar = smoothBar;
        this.offset = offset;
        this.showBackground = showBackground;
    }

    @Override
    public void Render(FontRenderer fontRenderer, int xPosition, int yPosition) {
        double height = this.smoothBar ? this.durabilityPercent * 13.0 : (double)Math.round(this.durabilityPercent * 13.0);
        int k = (int)Math.round(this.durabilityPercent * 255.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        int i1 = (255 - k) / 4 << 16 | 0x3F00;
        if (this.showBackground) {
            VerticalBarRenderer.renderQuad(xPosition + this.offset, yPosition + 2, 2.0, 13.0, 0);
            VerticalBarRenderer.renderQuad(xPosition + this.offset, yPosition + 2, 1.0, 12.0, i1);
        }
        VerticalBarRenderer.renderQuad(xPosition + this.offset, yPosition + 2, 1.0, height, this.color);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderQuad(double xPosition, double yPosition, double width, double height, int color) {
        tessellator.func_78382_b();
        tessellator.func_78378_d(color);
        tessellator.func_78377_a(xPosition, yPosition + 13.0 - height, 0.0);
        tessellator.func_78377_a(xPosition, yPosition + 13.0, 0.0);
        tessellator.func_78377_a(xPosition + width, yPosition + 13.0, 0.0);
        tessellator.func_78377_a(xPosition + width, yPosition + 13.0 - height, 0.0);
        tessellator.func_78381_a();
    }
}

