/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.core.lib.render.RenderEntityBlock;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.render.PipeTransportRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PipeTransportPowerRenderer
extends PipeTransportRenderer<PipeTransportPower> {
    public static final int POWER_STAGES = 256;
    public static final int[] displayPowerList = new int[256];
    public static final int[] displayPowerListOverload = new int[256];
    private static final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private static final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final float POWER_MAGIC = 0.7f;
    private static boolean initialized = false;

    protected static void clear() {
        if (initialized) {
            for (int i = 0; i < 256; ++i) {
                GL11.glDeleteLists((int)displayPowerList[i], (int)1);
                GL11.glDeleteLists((int)displayPowerListOverload[i], (int)1);
            }
        }
        initialized = false;
    }

    @Override
    public boolean useServerTileIfPresent() {
        return true;
    }

    private void initializeDisplayPowerList(World world) {
        float unit;
        float minSize;
        int s;
        if (initialized) {
            return;
        }
        initialized = true;
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Normal.ordinal());
        float size = 0.5f;
        for (s = 0; s < 256; ++s) {
            PipeTransportPowerRenderer.displayPowerList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayPowerList[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 256.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Overload.ordinal());
        size = 0.5f;
        for (s = 0; s < 256; ++s) {
            PipeTransportPowerRenderer.displayPowerListOverload[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayPowerListOverload[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 256.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
    }

    @Override
    public void render(Pipe<PipeTransportPower> pipe, double x, double y, double z, float f) {
        this.initializeDisplayPowerList(pipe.container.func_145831_w());
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.bindTexture(TextureMap.field_110575_b);
        int[] displayList = pow.overload > 0 ? displayPowerListOverload : displayPowerList;
        for (int side = 0; side < 6; ++side) {
            int stage = (int)Math.ceil(Math.pow(pow.displayPower[side], 0.7f));
            if (stage < 1 || !pipe.container.isPipeConnected(ForgeDirection.getOrientation((int)side))) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)angleY[side], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)angleZ[side], (float)0.0f, (float)0.0f, (float)1.0f);
            float scale = 1.0f - (float)side * 1.0E-4f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (stage < displayList.length) {
                GL11.glCallList((int)displayList[stage]);
            } else {
                GL11.glCallList((int)displayList[displayList.length - 1]);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

