/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.api.utils.PositionedRect;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class ProjectionUtils {
    public static Vector3f unProject(PositionedRect rect, Vector3f eyePos, Vector3f lookat, int mouseX, int mouseY) {
        int width = rect.size.width;
        int height = rect.size.height;
        double aspectRatio = (double)width / (double)height;
        double fov = 0.5235987755982988;
        double a = -((double)(mouseX - rect.position.x) / (double)width - 0.5) * 2.0;
        double b = -((double)(height - (mouseY - rect.position.y)) / (double)height - 0.5) * 2.0;
        double tanf = Math.tan(fov);
        Vector3f lookVec = new Vector3f();
        Vector3f.sub((Vector3f)eyePos, (Vector3f)lookat, (Vector3f)lookVec);
        float yawn = (float)Math.atan2(lookVec.x, -lookVec.z);
        float pitch = (float)Math.atan2(lookVec.y, Math.sqrt(lookVec.x * lookVec.x + lookVec.z * lookVec.z));
        Matrix4f rot = new Matrix4f();
        rot.rotate(yawn, new Vector3f(0.0f, -1.0f, 0.0f));
        rot.rotate(pitch, new Vector3f(1.0f, 0.0f, 0.0f));
        Vector4f foward = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
        Vector4f up = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
        Vector4f left = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)foward, (Vector4f)foward);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)up, (Vector4f)up);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)left, (Vector4f)left);
        Vector3f result = new Vector3f(foward.x, foward.y, foward.z);
        Vector3f.add((Vector3f)result, (Vector3f)new Vector3f((float)((double)left.x * tanf * aspectRatio * a), (float)((double)left.y * tanf * aspectRatio * a), (float)((double)left.z * tanf * aspectRatio * a)), (Vector3f)result);
        Vector3f.add((Vector3f)result, (Vector3f)new Vector3f((float)((double)up.x * tanf * b), (float)((double)up.y * tanf * b), (float)((double)up.z * tanf * b)), (Vector3f)result);
        return ProjectionUtils.normalize(result);
    }

    public static Vector3f normalize(Vector3f vec) {
        float length = (float)Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
        vec.x /= length;
        vec.y /= length;
        vec.z /= length;
        return vec;
    }
}

