/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.designer;

import binnie.botany.Botany;
import binnie.botany.ceramic.CeramicDesignSystem;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.carpentry.BlockDesign;
import binnie.extratrees.carpentry.DesignSystem;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ModuleCarpentry;
import java.util.Locale;
import net.minecraft.item.ItemStack;

public enum DesignerType {
    WOODWORKER("extratrees/carpenter_"),
    PANELWORKER("extratrees/paneler_"),
    GLASSWORKER("extratrees/paneler_"),
    TILEWORKER("extratrees/tileworker_");

    public final String name = this.name().toLowerCase(Locale.ENGLISH);
    public final String texture;

    private DesignerType(String texture) {
        this.texture = texture;
    }

    public IDesignSystem getSystem() {
        IDesignSystem iDesignSystem;
        switch (this) {
            case GLASSWORKER: {
                iDesignSystem = DesignSystem.Glass;
                break;
            }
            case TILEWORKER: {
                iDesignSystem = CeramicDesignSystem.instance;
                break;
            }
            default: {
                iDesignSystem = DesignSystem.Wood;
            }
        }
        return iDesignSystem;
    }

    public ItemStack getBlock(IDesignMaterial type1, IDesignMaterial type2, IDesign design) {
        int stackSize = 2;
        if (design == EnumDesign.Blank) {
            type2 = type1;
            stackSize = 1;
        }
        ItemStack stack = ModuleCarpentry.getItemStack(this.getBlock(), type1, type2, design);
        stack.field_77994_a = stackSize;
        return stack;
    }

    private BlockDesign getBlock() {
        BlockDesign blockDesign;
        switch (this) {
            case GLASSWORKER: {
                blockDesign = ExtraTrees.blockStained;
                break;
            }
            case PANELWORKER: {
                blockDesign = ExtraTrees.blockPanel;
                break;
            }
            case TILEWORKER: {
                blockDesign = Botany.ceramicTile;
                break;
            }
            default: {
                blockDesign = ExtraTrees.blockCarpentry;
            }
        }
        return blockDesign;
    }

    public ItemStack getDisplayStack(IDesign design) {
        return this.getBlock(this.getSystem().getDefaultMaterial(), this.getSystem().getDefaultMaterial2(), design);
    }

    public String getMaterialTooltip() {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GLASSWORKER: {
                string = I18N.localise("extratrees.machine.glassworker.material");
                break;
            }
            case PANELWORKER: {
                string = I18N.localise("extratrees.machine.panelworker.material");
                break;
            }
            case TILEWORKER: {
                string = I18N.localise("extratrees.machine.tileworker.material");
                break;
            }
            case WOODWORKER: {
                string = I18N.localise("extratrees.machine.woodworker.material");
            }
        }
        return string;
    }
}

