/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.craftgui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.Widget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlFluidDisplay
extends Control
implements ITooltip {
    public boolean hasTooltip = false;
    protected FluidStack itemStack = null;

    public ControlFluidDisplay(IWidget parent, float f, float y) {
        this(parent, f, y, 16.0f);
    }

    public ControlFluidDisplay(IWidget parent, float f, float y, FluidStack stack, boolean tooltip) {
        this(parent, f, y, 16.0f);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlFluidDisplay(IWidget parent, float x, float y, float size) {
        super(parent, x, y, size, size);
    }

    public void setTooltip() {
        this.hasTooltip = true;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    @Override
    public void onRenderForeground() {
        if (this.itemStack == null) {
            return;
        }
        IPoint relativeToWindow = this.getAbsolutePosition().sub(this.getSuperParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100.0f || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100.0f || this.itemStack == null) {
            return;
        }
        Fluid fluid = this.itemStack.getFluid();
        int hex = fluid.getColor(this.itemStack);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.getSize().x() != 16.0f) {
            GL11.glPushMatrix();
            float scale = this.getSize().x() / 16.0f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            CraftGUI.render.iconBlock(IPoint.ZERO, this.itemStack.getFluid().getIcon(this.itemStack));
            GL11.glPopMatrix();
        } else {
            CraftGUI.render.iconBlock(IPoint.ZERO, this.itemStack.getFluid().getIcon(this.itemStack));
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setItemStack(FluidStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.hasTooltip && this.itemStack != null) {
            tooltip.add(this.itemStack.getLocalizedName());
        }
    }
}

