/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.IPattern;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.DesignerManager;
import binnie.extratrees.carpentry.EnumPattern;
import binnie.extratrees.carpentry.GlassType;
import binnie.extratrees.item.ExtraTreeItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum DesignSystem implements IDesignSystem
{
    Wood,
    Glass;

    private final Map<Integer, IIcon> primary = new HashMap<Integer, IIcon>();
    private final Map<Integer, IIcon> secondary = new HashMap<Integer, IIcon>();

    private DesignSystem() {
        DesignerManager.instance.registerDesignSystem(this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial() {
        IDesignMaterial iDesignMaterial;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                iDesignMaterial = GlassType.get(0);
                break;
            }
            case Wood: {
                iDesignMaterial = PlankType.ExtraTreePlanks.Fir;
            }
        }
        return iDesignMaterial;
    }

    @Override
    public IDesignMaterial getDefaultMaterial2() {
        IDesignMaterial iDesignMaterial;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                iDesignMaterial = GlassType.get(1);
                break;
            }
            case Wood: {
                iDesignMaterial = PlankType.ExtraTreePlanks.Whitebeam;
            }
        }
        return iDesignMaterial;
    }

    @Override
    public IDesignMaterial getMaterial(int id) {
        IDesignMaterial iDesignMaterial;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                iDesignMaterial = GlassType.get(id);
                break;
            }
            case Wood: {
                iDesignMaterial = CarpentryManager.carpentryInterface.getWoodMaterial(id);
            }
        }
        return iDesignMaterial;
    }

    @Override
    public int getMaterialIndex(IDesignMaterial id) {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                n = GlassType.getIndex(id);
                break;
            }
            case Wood: {
                n = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(id);
            }
        }
        return n;
    }

    public String getTexturePath() {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                string = "glass";
                break;
            }
            case Wood: {
                string = "patterns";
            }
        }
        return string;
    }

    @Override
    public IDesignMaterial getMaterial(ItemStack stack) {
        IDesignMaterial iDesignMaterial;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                iDesignMaterial = GlassType.get(stack);
                break;
            }
            case Wood: {
                iDesignMaterial = CarpentryManager.carpentryInterface.getWoodMaterial(stack);
            }
        }
        return iDesignMaterial;
    }

    @Override
    public ItemStack getAdhesive() {
        ItemStack itemStack;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Glass: {
                itemStack = ExtraTreeItems.GlassFitting.get(1);
                break;
            }
            case Wood: {
                itemStack = ExtraTreeItems.WoodWax.get(1);
            }
        }
        return itemStack;
    }

    @Override
    public IIcon getPrimaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.primary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public IIcon getSecondaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.secondary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        for (EnumPattern pattern : EnumPattern.VALUES) {
            this.primary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".0"));
            this.secondary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".1"));
        }
    }

    public AbstractMod getMod() {
        return ExtraTrees.instance;
    }
}

