/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.util.I18N;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.ILayout;
import binnie.extratrees.api.IToolHammer;
import binnie.extratrees.carpentry.BlockCarpentryPanel;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ModuleCarpentry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DesignBlock {
    protected IDesign design;
    protected IDesignMaterial primaryMaterial;
    protected IDesignMaterial secondaryMaterial;
    protected int rotation = 0;
    protected ForgeDirection facing;
    protected boolean panel;

    DesignBlock(IDesignSystem system, IDesignMaterial primaryWood, IDesignMaterial secondaryWood, IDesign design, int rotation, ForgeDirection dir) {
        this.design = design;
        this.rotation = rotation;
        this.facing = ForgeDirection.UP;
        this.panel = false;
        this.primaryMaterial = primaryWood;
        this.secondaryMaterial = secondaryWood;
        this.facing = dir;
        if (design == null) {
            this.design = EnumDesign.Blank;
        }
        if (primaryWood == null) {
            this.primaryMaterial = system.getDefaultMaterial();
        }
        if (secondaryWood == null) {
            this.secondaryMaterial = system.getDefaultMaterial();
        }
        if (rotation > 3 || rotation < 0) {
            this.rotation = 0;
        }
        if (this.facing == null || this.facing == ForgeDirection.UNKNOWN) {
            this.facing = ForgeDirection.UP;
        }
    }

    public String toString() {
        return super.toString() + " { design:" + this.design + " }, { primary:" + this.primaryMaterial + " }, { secondary:" + this.secondaryMaterial + " }, { rotation:" + this.rotation + " }, { facing:" + this.facing + " }";
    }

    public IDesign getDesign() {
        return this.design;
    }

    public IDesignMaterial getPrimaryMaterial() {
        return this.primaryMaterial;
    }

    public IDesignMaterial getSecondaryMaterial() {
        return this.secondaryMaterial;
    }

    public int getPrimaryColour() {
        return this.getPrimaryMaterial().getColor();
    }

    public int getSecondaryColour() {
        return this.getSecondaryMaterial().getColor();
    }

    public ILayout getLayout(ForgeDirection dir) {
        ILayout iLayout;
        ForgeDirection adjustedDir;
        dir = adjustedDir = dir.getRotation(ForgeDirection.DOWN);
        switch (this.getFacing()) {
            case DOWN: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                break;
            }
            case EAST: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.NORTH);
                break;
            }
            case NORTH: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
                break;
            }
            case SOUTH: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                break;
            }
            case WEST: {
                adjustedDir = adjustedDir.getRotation(ForgeDirection.EAST);
                adjustedDir = adjustedDir.getRotation(ForgeDirection.SOUTH);
            }
        }
        for (int i = 0; i < this.rotation; ++i) {
            adjustedDir = adjustedDir.getRotation(ForgeDirection.DOWN);
        }
        switch (adjustedDir) {
            case EAST: {
                iLayout = this.getDesign().getEastPattern();
                break;
            }
            case NORTH: {
                iLayout = this.getDesign().getNorthPattern();
                break;
            }
            case SOUTH: {
                iLayout = this.getDesign().getSouthPattern();
                break;
            }
            case WEST: {
                iLayout = this.getDesign().getWestPattern();
                break;
            }
            case DOWN: {
                iLayout = this.getDesign().getBottomPattern();
                break;
            }
            default: {
                iLayout = this.getDesign().getTopPattern();
            }
        }
        ILayout layout = iLayout;
        block14 : switch (this.getFacing()) {
            case UP: {
                if (dir != ForgeDirection.DOWN && dir != ForgeDirection.UP) break;
                for (int j = 0; j < this.rotation; ++j) {
                    layout = layout.rotateRight();
                }
                break;
            }
            case DOWN: {
                switch (dir) {
                    case DOWN: 
                    case UP: {
                        layout = layout.flipVertical();
                        break;
                    }
                    case EAST: 
                    case NORTH: 
                    case SOUTH: 
                    case WEST: {
                        layout = layout.rotateRight().rotateRight();
                    }
                }
                if (dir != ForgeDirection.DOWN && dir != ForgeDirection.UP) break;
                for (int j = 0; j < this.rotation; ++j) {
                    layout = layout.rotateLeft();
                }
                break;
            }
            case EAST: {
                int j;
                switch (dir) {
                    case SOUTH: 
                    case UP: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case NORTH: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case DOWN: {
                        layout = layout.rotateLeft().flipHorizontal();
                        break;
                    }
                    case WEST: {
                        layout = layout.flipHorizontal();
                    }
                }
                if (dir == ForgeDirection.EAST) {
                    for (j = 0; j < this.rotation; ++j) {
                        layout = layout.rotateRight();
                    }
                }
                if (dir != ForgeDirection.WEST) break;
                for (j = 0; j < this.rotation; ++j) {
                    layout = layout.rotateLeft();
                }
                break;
            }
            case WEST: {
                switch (dir) {
                    case NORTH: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case SOUTH: 
                    case UP: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case DOWN: {
                        layout = layout.rotateLeft().flipVertical();
                        break;
                    }
                    case EAST: {
                        layout = layout.flipHorizontal();
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case WEST: {
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateRight();
                        }
                    }
                }
                break;
            }
            case NORTH: {
                switch (dir) {
                    case WEST: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case EAST: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case DOWN: {
                        layout = layout.flipHorizontal();
                        break;
                    }
                    case SOUTH: {
                        layout = layout.flipHorizontal();
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case NORTH: {
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateRight();
                        }
                        break block14;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (dir) {
                    case EAST: {
                        layout = layout.rotateLeft();
                        break;
                    }
                    case WEST: {
                        layout = layout.rotateRight();
                        break;
                    }
                    case UP: {
                        layout = layout.rotateRight().rotateRight();
                        break;
                    }
                    case DOWN: {
                        layout = layout.flipVertical();
                        break;
                    }
                    case NORTH: {
                        layout = layout.flipHorizontal();
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateLeft();
                        }
                        break block14;
                    }
                    case SOUTH: {
                        for (int j = 0; j < this.rotation; ++j) {
                            layout = layout.rotateRight();
                        }
                        break block14;
                    }
                }
                break;
            }
        }
        return layout;
    }

    public IIcon getPrimaryIcon(IDesignSystem system, ForgeDirection dir) {
        ILayout layout = this.getLayout(dir);
        return layout == null ? null : layout.getPrimaryIcon(system);
    }

    public IIcon getSecondaryIcon(IDesignSystem system, ForgeDirection dir) {
        ILayout layout = this.getLayout(dir);
        return layout == null ? null : layout.getSecondaryIcon(system);
    }

    public IIcon getIcon(IDesignSystem system, boolean secondary, ForgeDirection dir) {
        return secondary ? this.getSecondaryIcon(system, dir) : this.getPrimaryIcon(system, dir);
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public void setFacing(ForgeDirection facing) {
        this.facing = facing;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void rotate(int face, ItemStack hammer, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)face);
        IToolHammer hammerI = (IToolHammer)hammer.func_77973_b();
        if (player.func_70093_af()) {
            if (this.panel) {
                ForgeDirection newFacing = this.getFacing();
                do {
                    if ((newFacing = ForgeDirection.getOrientation((int)(newFacing.ordinal() + 1))) != ForgeDirection.UNKNOWN) continue;
                    newFacing = ForgeDirection.DOWN;
                } while (newFacing != this.getFacing() && !BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, newFacing));
                if (newFacing != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(newFacing);
            } else {
                if (dir != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(dir);
            }
        } else {
            ++this.rotation;
            hammerI.onHammerUsed(hammer, player);
        }
        if (this.rotation > 3) {
            this.rotation = 0;
        } else if (this.rotation < 0) {
            this.rotation = 3;
        }
    }

    public int getBlockMetadata(IDesignSystem system) {
        return ModuleCarpentry.getBlockMetadata(system, this);
    }

    public int getItemMetadata(IDesignSystem system) {
        return ModuleCarpentry.getItemMetadata(system, this);
    }

    public void setPanel() {
        this.panel = true;
    }

    public String getString() {
        String type = this.getPrimaryMaterial() != this.getSecondaryMaterial() ? I18N.localise("extratrees.block.tooltip.twoMaterials", this.getPrimaryMaterial().getName(), this.getSecondaryMaterial().getName()) : this.getPrimaryMaterial().getName();
        return super.toString() + " {" + type + " " + this.getDesign().getName() + " " + (this.panel ? "Panel" : "Tile") + ", Facing:" + this.getFacing().toString() + ", Rotation:" + this.getRotation() + "}";
    }
}

