/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.gui.database.product;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.extrabees.gui.database.product.ControlProductsItem;
import binnie.extrabees.gui.database.product.Product;
import binnie.extrabees.gui.database.product.ProductType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ControlProductsBox
extends ControlListBox<Product> {
    protected IAlleleBeeSpecies species;
    private final ProductType type;

    public ControlProductsBox(IWidget parent, int x, int y, int width, int height, ProductType type) {
        super(parent, x, y, width, height, 12.0f);
        this.type = type;
        this.species = null;
    }

    @Override
    public IWidget createOption(Product value, int y) {
        return new ControlProductsItem((ControlList)this.getContent(), value, y);
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        if (species != this.species && (this.species = species) != null) {
            IAllele[] template = Binnie.Genetics.getBeeRoot().getTemplate(species.getUID());
            if (template == null) {
                return;
            }
            IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(template);
            float speed = genome.getSpeed();
            float modeSpeed = Binnie.Genetics.getBeeRoot().getBeekeepingMode(BinnieCore.proxy.getWorld()).getBeeModifier().getProductionModifier(genome, 1.0f);
            ArrayList<Product> strings = new ArrayList<Product>();
            Set chances = this.type == ProductType.PRODUCTS ? species.getProductChances().entrySet() : species.getSpecialtyChances().entrySet();
            for (Map.Entry entry : chances) {
                strings.add(new Product((ItemStack)entry.getKey(), speed * modeSpeed * ((Float)entry.getValue()).floatValue()));
            }
            this.setOptions(strings);
        }
    }
}

