/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import appeng.tile.networking.TileCableBus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a@\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"facingPosX", "", "Lappeng/parts/AEBasePart;", "getFacingPosX", "(Lappeng/parts/AEBasePart;)Ljava/lang/Integer;", "facingPosY", "getFacingPosY", "facingPosZ", "getFacingPosZ", "facingTile", "Lnet/minecraft/tileentity/TileEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/tileentity/TileEntity;", "getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/IBlockAccess;", "posX", "posY", "posZ", "getPart", "Lappeng/api/parts/IPart;", "hitX", "", "hitY", "hitZ", "betterp2p"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull IBlockAccess w, int posX, int posY, int posZ) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        ICableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = (ICableBusContainer)((TileCableBus)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull IBlockAccess w, int posX, int posY, int posZ, float hitX, float hitY, float hitZ) {
        SelectedPart p;
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Vec3 vec = Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ);
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart selectedPart = p = ((IPartHost)te).selectPart(vec);
        return selectedPart != null ? selectedPart.part : null;
    }

    @Nullable
    public static final Integer getFacingPosX(@NotNull AEBasePart $this$facingPosX) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosX, (String)"<this>");
        IPartHost iPartHost = $this$facingPosX.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosX.getSide();
            n = iPartHost.x & (forgeDirection != null ? forgeDirection.offsetX : EnumFacing.UP.func_82601_c());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosY(@NotNull AEBasePart $this$facingPosY) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosY, (String)"<this>");
        IPartHost iPartHost = $this$facingPosY.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosY.getSide();
            n = iPartHost.y & (forgeDirection != null ? forgeDirection.offsetY : EnumFacing.UP.func_96559_d());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosZ(@NotNull AEBasePart $this$facingPosZ) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosZ, (String)"<this>");
        IPartHost iPartHost = $this$facingPosZ.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosZ.getSide();
            n = iPartHost.z & (forgeDirection != null ? forgeDirection.offsetZ : EnumFacing.UP.func_82599_e());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final TileEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        Intrinsics.checkNotNullParameter((Object)$this$facingTile, (String)"<this>");
        if ($this$facingTile.getHost().isInWorld()) {
            Integer posX = CableBusUtilKt.getFacingPosX($this$facingTile);
            Integer posY = CableBusUtilKt.getFacingPosY($this$facingTile);
            Integer posZ = CableBusUtilKt.getFacingPosZ($this$facingTile);
            if (posX != null && posY != null && posZ != null) {
                IPartHost iPartHost = $this$facingTile.getHost();
                return iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getWorld()) != null ? iPartHost.func_147438_o(posX.intValue(), posY.intValue(), posZ.intValue()) : null;
            }
        }
        return null;
    }
}

