/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import mods.battlegear2.Battlegear;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BukkitWrapper {
    private static Object AIR;
    private static Object BLOCK;
    private static Object DENY;
    private static Method AirInteract;
    private static Method BlockInteract;
    private static Method IsCancelled;
    private static Method ItemUse;
    private static Method BlockUse;

    public static void callBukkitInteractEvent(PlayerInteractEvent playerInteracted, ItemStack stack) {
        if (AIR == null) {
            return;
        }
        try {
            if (playerInteracted.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                Object result = AirInteract.invoke(null, playerInteracted.entityPlayer, AIR, stack);
                if (result != null && ItemUse.invoke(result, new Object[0]) == DENY) {
                    playerInteracted.useItem = Event.Result.DENY;
                }
            } else {
                Object result = BlockInteract.invoke(null, playerInteracted.entityPlayer, BLOCK, playerInteracted.x, playerInteracted.y, playerInteracted.z, playerInteracted.face, stack);
                if (result != null) {
                    if (((Boolean)IsCancelled.invoke(result, new Object[0])).booleanValue()) {
                        playerInteracted.setCanceled(true);
                    } else {
                        if (ItemUse.invoke(result, new Object[0]) == DENY) {
                            playerInteracted.useItem = Event.Result.DENY;
                        }
                        if (BlockUse.invoke(result, new Object[0]) == DENY) {
                            playerInteracted.useBlock = Event.Result.DENY;
                        }
                    }
                }
            }
        }
        catch (Throwable logged) {
            Battlegear.logger.error(logged.getMessage());
        }
    }

    private static Class<?> exploreJar(JarFile jarPath, String relPath) throws ClassNotFoundException, IOException {
        Enumeration<JarEntry> entries = jarPath.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            if (!entryName.endsWith("CraftEventFactory.class") || !entryName.startsWith(relPath)) continue;
            return Class.forName(entryName.replace('/', '.').replace('\\', '.').replace(".class", ""));
        }
        return null;
    }

    private static Class<?> exploreDir(File directory, String pkgname) throws ClassNotFoundException {
        String[] files;
        for (String name : files = directory.list()) {
            Class<?> temp;
            if (name.endsWith("CraftEventFactory.class")) {
                return Class.forName(pkgname + '.' + name.substring(0, name.length() - 6));
            }
            File file = new File(directory, name);
            if (!file.isDirectory() || (temp = BukkitWrapper.exploreDir(file, pkgname + '.' + name)) == null) continue;
            return temp;
        }
        return null;
    }

    static {
        try {
            Class<?> temp = Class.forName("org.bukkit.event.block.Action");
            ?[] objs = temp.getEnumConstants();
            AIR = objs[3];
            BLOCK = objs[1];
            temp = Class.forName("org.bukkit.event.Event$Result");
            DENY = temp.getEnumConstants()[0];
            URL resource = ClassLoader.getSystemClassLoader().getResource("org/bukkit/craftbukkit");
            if (resource == null) {
                throw new RuntimeException("No resource at path org/bukkit/craftbukkit");
            }
            if (resource.getProtocol().equals("jar")) {
                Battlegear.logger.info("Loading CraftEventFactory from jar");
                temp = BukkitWrapper.exploreJar(((JarURLConnection)resource.openConnection()).getJarFile(), "org/bukkit/craftbukkit");
            } else {
                Battlegear.logger.info("Loading CraftEventFactory from directories");
                temp = BukkitWrapper.exploreDir(new File(URLDecoder.decode(resource.getPath(), "UTF-8")), "org.bukkit.craftbukkit");
            }
            if (temp == null) {
                throw new RuntimeException("Couldn't find event factory at path org/bukkit/craftbukkit");
            }
            for (Method m : temp.getMethods()) {
                if (m.getName().equals("callPlayerInteractEvent")) {
                    int i = m.getParameterTypes().length;
                    if (i == 3) {
                        AirInteract = m;
                    } else if (i == 7) {
                        BlockInteract = m;
                    }
                }
                if (AirInteract != null && BlockInteract != null) break;
            }
            temp = Class.forName("org.bukkit.event.player.PlayerInteractEvent");
            IsCancelled = temp.getMethod("isCancelled", new Class[0]);
            ItemUse = temp.getMethod("useItemInHand", new Class[0]);
            BlockUse = temp.getMethod("useInteractedBlock", new Class[0]);
        }
        catch (Throwable logged) {
            Battlegear.logger.error(logged.getMessage());
        }
    }
}

