/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.loader;

import appeng.api.recipes.IRecipeLoader;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;

public final class ConfigLoader
implements IRecipeLoader {
    private final File generatedRecipesDir;
    private final File userRecipesDir;

    public ConfigLoader(File generatedRecipesDir, File userRecipesDir) {
        this.generatedRecipesDir = generatedRecipesDir;
        this.userRecipesDir = userRecipesDir;
    }

    @Override
    public BufferedReader getFile(@Nonnull String relativeFilePath) throws Exception {
        Preconditions.checkNotNull((Object)relativeFilePath);
        Preconditions.checkArgument((!relativeFilePath.isEmpty() ? 1 : 0) != 0, (Object)"Supplying an empty String will result creating a reader of a folder.");
        File generatedFile = new File(this.generatedRecipesDir, relativeFilePath);
        File userFile = new File(this.userRecipesDir, relativeFilePath);
        File toBeLoaded = userFile.exists() && userFile.isFile() ? userFile : generatedFile;
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(toBeLoaded), "UTF-8"));
    }
}

