/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartMonitor;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class PartConversionMonitor
extends AbstractPartMonitor {
    private static final CableBusTextures FRONT_BRIGHT_ICON = CableBusTextures.PartConversionMonitor_Bright;
    private static final CableBusTextures FRONT_DARK_ICON = CableBusTextures.PartConversionMonitor_Dark;
    private static final CableBusTextures FRONT_DARK_ICON_LOCKED = CableBusTextures.PartConversionMonitor_Dark_Locked;
    private static final CableBusTextures FRONT_COLORED_ICON = CableBusTextures.PartConversionMonitor_Colored;

    public PartConversionMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        boolean ModeB = false;
        ItemStack item = player.func_71045_bC();
        if (item == null && this.getDisplayed() != null) {
            ModeB = true;
            item = ((IAEItemStack)this.getDisplayed()).getItemStack();
        }
        if (item != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return false;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getItemInventory();
                AEItemStack input = AEItemStack.create(item);
                if (ModeB) {
                    for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                        ItemStack targetStack = player.field_71071_by.func_70301_a(x);
                        if (!((Object)input).equals(targetStack)) continue;
                        IAEItemStack insertItem = input.copy();
                        insertItem.setStackSize(targetStack.field_77994_a);
                        IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, insertItem, new PlayerSource(player, this));
                        player.field_71071_by.func_70299_a(x, failedToInsert == null ? null : failedToInsert.getItemStack());
                    }
                } else {
                    IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, failedToInsert == null ? null : failedToInsert.getItemStack());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected void extractItem(EntityPlayer player) {
        IAEItemStack input = (IAEItemStack)this.getDisplayed();
        if (input != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getItemInventory();
                ItemStack is = input.getItemStack();
                input.setStackSize(is.func_77976_d());
                IAEItemStack retrieved = Platform.poweredExtraction(energy, cell, input, new PlayerSource(player, this));
                if (retrieved != null) {
                    ItemStack newItems = retrieved.getItemStack();
                    InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                    newItems = adaptor.addItems(newItems);
                    if (newItems != null) {
                        TileEntity te = this.getTile();
                        List<ItemStack> list = Collections.singletonList(newItems);
                        Platform.spawnDrops(player.field_70170_p, te.field_145851_c + this.getSide().offsetX, te.field_145848_d + this.getSide().offsetY, te.field_145849_e + this.getSide().offsetZ, list);
                    }
                    if (player.field_71070_bA != null) {
                        player.field_71070_bA.func_75142_b();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public CableBusTextures getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public CableBusTextures getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public CableBusTextures getFrontDark() {
        return this.isLocked() ? FRONT_DARK_ICON_LOCKED : FRONT_DARK_ICON;
    }
}

