/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.ContainerOptimizePatterns;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketOptimizePatterns
extends AppEngPacket {
    HashMap<Integer, Integer> hashCodeToMultiplier = new HashMap();

    public PacketOptimizePatterns(ByteBuf data) {
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            this.hashCodeToMultiplier.put(data.readInt(), data.readInt());
        }
    }

    public PacketOptimizePatterns(HashMap<IAEItemStack, Integer> multipliersMap) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(multipliersMap.size());
        for (Map.Entry<IAEItemStack, Integer> entry : multipliersMap.entrySet()) {
            long encoded = entry.getKey().getStackSize();
            data.writeInt((int)(encoded >> 6) * ((encoded & 0x20L) == 0L ? 1 : -1));
            data.writeInt(entry.getValue().intValue());
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerOptimizePatterns) {
            ContainerOptimizePatterns cop = (ContainerOptimizePatterns)container;
            cop.optimizePatterns(this.hashCodeToMultiplier);
        }
    }
}

