/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.config.TypeFilter;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.AppEngRenderItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.item.Item;

public final class ItemDisplayRegistry
implements IItemDisplayRegistry {
    private final Set<Class<? extends Item>> blacklistedItemClasses = new HashSet<Class<? extends Item>>();
    private final Set<Item> blacklistedItems = new HashSet<Item>();
    private final List<BiPredicate<TypeFilter, IAEItemStack>> itemFilters = new ArrayList<BiPredicate<TypeFilter, IAEItemStack>>();

    @Override
    public void blacklistItemDisplay(Item item) {
        this.blacklistedItems.add(item);
    }

    @Override
    public void blacklistItemDisplay(Class<? extends Item> item) {
        this.blacklistedItemClasses.add(item);
    }

    @Override
    public boolean isBlacklisted(Item item) {
        return this.blacklistedItems.contains(item);
    }

    @Override
    public boolean isBlacklisted(Class<? extends Item> item) {
        return this.blacklistedItemClasses.contains(item);
    }

    @Override
    public void addItemFilter(BiPredicate<TypeFilter, IAEItemStack> filter) {
        this.itemFilters.add(filter);
    }

    @Override
    public List<BiPredicate<TypeFilter, IAEItemStack>> getItemFilters() {
        return this.itemFilters;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addPostItemRenderHook(IItemDisplayRegistry.ItemRenderHook hook) {
        AppEngRenderItem.POST_HOOKS.add(hook);
    }
}

