/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.definitions.IDefinitions;
import appeng.api.parts.IPartHelper;
import appeng.core.FeatureHandlerRegistry;
import appeng.core.FeatureRegistry;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.api.definitions.ApiMaterials;
import appeng.core.api.definitions.ApiParts;
import appeng.core.api.definitions.DefinitionConstructor;

public final class ApiDefinitions
implements IDefinitions {
    private final ApiBlocks blocks;
    private final ApiItems items;
    private final ApiMaterials materials;
    private final ApiParts parts;
    private final FeatureHandlerRegistry handlers;
    private final FeatureRegistry features = new FeatureRegistry();

    public ApiDefinitions(IPartHelper partHelper) {
        this.handlers = new FeatureHandlerRegistry();
        DefinitionConstructor constructor = new DefinitionConstructor(this.features, this.handlers);
        this.blocks = new ApiBlocks(constructor);
        this.items = new ApiItems(constructor);
        this.materials = new ApiMaterials(constructor);
        this.parts = new ApiParts(constructor, partHelper);
    }

    FeatureHandlerRegistry getFeatureHandlerRegistry() {
        return this.handlers;
    }

    FeatureRegistry getFeatureRegistry() {
        return this.features;
    }

    @Override
    public ApiBlocks blocks() {
        return this.blocks;
    }

    @Override
    public ApiItems items() {
        return this.items;
    }

    @Override
    public ApiMaterials materials() {
        return this.materials;
    }

    @Override
    public ApiParts parts() {
        return this.parts;
    }
}

