/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import appeng.container.interfaces.IProgressProvider;
import appeng.core.localization.GuiText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public class GuiProgressBar
extends GuiButton
implements ITooltip {
    private final IProgressProvider source;
    private final ResourceLocation texture;
    private final int fill_u;
    private final int fill_v;
    private final Direction layout;
    private final String titleName;
    private String fullMsg;

    public GuiProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir) {
        this(source, texture, posX, posY, u, y, width, height, dir, null);
    }

    public GuiProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir, String title) {
        super(posX, posY, width, "");
        this.source = source;
        this.field_146128_h = posX;
        this.field_146129_i = posY;
        this.texture = new ResourceLocation("appliedenergistics2", "textures/" + texture);
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.fill_u = u;
        this.fill_v = y;
        this.layout = dir;
        this.titleName = title;
    }

    public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            par1Minecraft.func_110434_K().func_110577_a(this.texture);
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            if (this.layout == Direction.VERTICAL) {
                int diff = this.field_146121_g - (max > 0 ? this.field_146121_g * current / max : 0);
                this.func_73729_b(this.field_146128_h, this.field_146129_i + diff, this.fill_u, this.fill_v + diff, this.field_146120_f, this.field_146121_g - diff);
            } else {
                int diff = this.field_146120_f - (max > 0 ? this.field_146120_f * current / max : 0);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.fill_u + diff, this.fill_v, this.field_146120_f - diff, this.field_146121_g);
            }
            this.func_146119_b(par1Minecraft, par2, par3);
        }
    }

    public void setFullMsg(String msg) {
        this.fullMsg = msg;
    }

    @Override
    public String getMessage() {
        if (this.fullMsg != null) {
            return this.fullMsg;
        }
        return (this.titleName != null ? this.titleName : "") + '\n' + this.source.getCurrentProgress() + ' ' + GuiText.Of.getLocal() + ' ' + this.source.getMaxProgress();
    }

    @Override
    public int xPos() {
        return this.field_146128_h - 2;
    }

    @Override
    public int yPos() {
        return this.field_146129_i - 2;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f + 4;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g + 4;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

