/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import me.jellysquid.mods.sodium.client.gl.compat.FogHelper;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import org.lwjgl.opengl.GL20;

public abstract class ChunkShaderFogComponent {
    public abstract void setup();

    public static class Linear
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogLength;
        private final int uFogEnd;

        public Linear(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogLength = program.getUniformLocation("u_FogLength");
            this.uFogEnd = program.getUniformLocation("u_FogEnd");
        }

        @Override
        public void setup() {
            float end = FogHelper.getFogEnd();
            float start = FogHelper.getFogStart();
            float[] color = FogHelper.getFogColor();
            GL20.glUniform4f((int)this.uFogColor, (float)color[0], (float)color[1], (float)color[2], (float)color[3]);
            GL20.glUniform1f((int)this.uFogLength, (float)(end - start));
            GL20.glUniform1f((int)this.uFogEnd, (float)end);
        }
    }

    public static class Exp2
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogDensity;

        public Exp2(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogDensity = program.getUniformLocation("u_FogDensity");
        }

        @Override
        public void setup() {
            float[] fc = FogHelper.getFogColor();
            GL20.glUniform4f((int)this.uFogColor, (float)fc[0], (float)fc[1], (float)fc[2], (float)fc[3]);
            GL20.glUniform1f((int)this.uFogDensity, (float)FogHelper.getFogDensity());
        }
    }

    public static class None
    extends ChunkShaderFogComponent {
        public None(ChunkProgram program) {
        }

        @Override
        public void setup() {
        }
    }
}

