/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.gtnewhorizon.gtnhlib.client.renderer.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkRenderColumn<T extends ChunkGraphicsState> {
    private final ChunkRenderContainer<T>[] renders = new ChunkRenderContainer[16];
    private final ChunkRenderColumn<T>[] adjacent = new ChunkRenderColumn[6];
    private final int x;
    private final int z;

    public ChunkRenderColumn(int x, int z) {
        this.x = x;
        this.z = z;
        this.setAdjacentColumn(ForgeDirection.UP, this);
        this.setAdjacentColumn(ForgeDirection.DOWN, this);
    }

    public void setAdjacentColumn(ForgeDirection dir, ChunkRenderColumn<T> column) {
        this.adjacent[dir.ordinal()] = column;
    }

    public ChunkRenderColumn<T> getAdjacentColumn(ForgeDirection dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setRender(int y, ChunkRenderContainer<T> render) {
        this.renders[y] = render;
    }

    public ChunkRenderContainer<T> getRender(int y) {
        if (y < 0 || y >= this.renders.length) {
            return null;
        }
        return this.renders[y];
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean areNeighborsPresent() {
        for (ForgeDirection dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            ForgeDirection corner;
            ChunkRenderColumn<T> adj = this.adjacent[dir.ordinal()];
            if (adj == null) {
                return false;
            }
            if (dir == ForgeDirection.NORTH) {
                corner = ForgeDirection.EAST;
            } else if (dir == ForgeDirection.SOUTH) {
                corner = ForgeDirection.WEST;
            } else if (dir == ForgeDirection.WEST) {
                corner = ForgeDirection.NORTH;
            } else {
                if (dir != ForgeDirection.EAST) continue;
                corner = ForgeDirection.SOUTH;
            }
            if (adj.getAdjacentColumn(corner) != null) continue;
            return false;
        }
        return true;
    }
}

