/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.gtnewhorizons.angelica.compat.mojang.Drawable;
import com.gtnewhorizons.angelica.compat.mojang.Element;
import com.gtnewhorizons.angelica.compat.mojang.ParentElement;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.shadow.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public abstract class AbstractFrame
extends AbstractWidget
implements ParentElement {
    protected final Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<Drawable> drawable = new ArrayList<Drawable>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    protected boolean renderOutline;
    private Element focused;
    private boolean dragging;

    public AbstractFrame(Dim2i dim, boolean renderOutline) {
        this.dim = dim;
        this.renderOutline = renderOutline;
    }

    public void buildFrame() {
        for (Element element : this.children) {
            if (element instanceof AbstractFrame) {
                AbstractFrame abstractFrame = (AbstractFrame)element;
                this.controlElements.addAll(abstractFrame.controlElements);
            }
            if (element instanceof ControlElement) {
                ControlElement controlElement = (ControlElement)((Object)element);
                this.controlElements.add(controlElement);
            }
            if (!(element instanceof Drawable)) continue;
            Drawable drawable = (Drawable)((Object)element);
            this.drawable.add(drawable);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (this.renderOutline) {
            this.drawRectOutline(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        }
        for (Drawable drawable : this.drawable) {
            drawable.render(mouseX, mouseY, delta);
        }
    }

    public void applyScissor(int x, int y, int width, int height, Runnable action) {
        double scale = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d).func_78325_e();
        GLStateManager.enableScissorTest();
        GL11.glScissor((int)((int)((double)x * scale)), (int)((int)((double)Minecraft.func_71410_x().func_147110_a().field_147618_d - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
        action.run();
        GLStateManager.disableScissorTest();
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            AbstractFrame.addQuad(vertices, x, y, w, y + 1.0, a, r, g, b);
            AbstractFrame.addQuad(vertices, x, h - 1.0, w, h, a, r, g, b);
            AbstractFrame.addQuad(vertices, x, y, x + 1.0, h, a, r, g, b);
            AbstractFrame.addQuad(vertices, w - 1.0, y, w, h, a, r, g, b);
        });
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    @Nullable
    public Element getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(@Nullable Element focused) {
        this.focused = focused;
    }

    @Override
    public List<? extends Element> children() {
        return this.children;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }
}

