/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.anarres.cpp;

import com.gtnewhorizons.angelica.shadow.javax.annotation.Nonnegative;
import com.gtnewhorizons.angelica.shadow.javax.annotation.Nonnull;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.LexerException;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.PreprocessorListener;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Source;
import com.gtnewhorizons.angelica.shadow.org.slf4j.Logger;
import com.gtnewhorizons.angelica.shadow.org.slf4j.LoggerFactory;

public class DefaultPreprocessorListener
implements PreprocessorListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPreprocessorListener.class);
    private int errors;
    private int warnings;

    public DefaultPreprocessorListener() {
        this.clear();
    }

    public void clear() {
        this.errors = 0;
        this.warnings = 0;
    }

    @Nonnegative
    public int getErrors() {
        return this.errors;
    }

    @Nonnegative
    public int getWarnings() {
        return this.warnings;
    }

    protected void print(@Nonnull String msg) {
        LOG.info(msg);
    }

    public void handleWarning(Source source, int line, int column, String msg) throws LexerException {
        ++this.warnings;
        this.print(source.getName() + ":" + line + ":" + column + ": warning: " + msg);
    }

    public void handleError(Source source, int line, int column, String msg) throws LexerException {
        ++this.errors;
        this.print(source.getName() + ":" + line + ":" + column + ": error: " + msg);
    }

    public void handleSourceChange(Source source, PreprocessorListener.SourceChangeEvent event) {
    }
}

