/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.lwjgl.BufferUtils;

public class RenderingState {
    public static final RenderingState INSTANCE = new RenderingState();
    private final Vector3d cameraPosition = new Vector3d();
    private final FloatBuffer projectionBuffer = BufferUtils.createFloatBuffer((int)16);
    private final FloatBuffer modelViewBuffer = BufferUtils.createFloatBuffer((int)16);
    private final Matrix4f projectionMatrix = new Matrix4f().identity();
    private final Matrix4f modelViewMatrix = new Matrix4f().identity();
    private float fov;

    public void setCameraPosition(double x, double y, double z) {
        this.cameraPosition.set(x, y, z);
    }

    public void setProjectionMatrix(FloatBuffer projection) {
        this.projectionMatrix.set(projection);
        this.projectionMatrix.get(0, this.projectionBuffer);
    }

    public void setModelViewMatrix(FloatBuffer modelview) {
        this.modelViewMatrix.set(modelview);
        this.modelViewMatrix.get(0, this.modelViewBuffer);
    }

    public Vector3d getCameraPosition() {
        return this.cameraPosition;
    }

    public FloatBuffer getProjectionBuffer() {
        return this.projectionBuffer;
    }

    public FloatBuffer getModelViewBuffer() {
        return this.modelViewBuffer;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4f getModelViewMatrix() {
        return this.modelViewMatrix;
    }

    public float getFov() {
        return this.fov;
    }

    public void setFov(float fov) {
        this.fov = fov;
    }
}

