/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="angelica", filename="angelica-modules")
public class AngelicaConfig {
    @Config.Comment(value={"Enable Sodium rendering"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableSodium;
    @Config.Comment(value={"Enable NotFine Options"})
    @Config.DefaultBoolean(value=false)
    public static boolean enableNotFineOptions;
    @Config.Comment(value={"Enable Reese's Sodium Options"})
    @Config.DefaultBoolean(value=true)
    public static boolean enableReesesSodiumOptions;
    @Config.Comment(value={"Enable Sodium fluid rendering"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableSodiumFluidRendering;
    @Config.Comment(value={"Inject QuadProvider rendering into some vanilla blocks"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean injectQPRendering;
    @Config.Comment(value={"Enable Angelica's test blocks"})
    @Config.DefaultBoolean(value=false)
    @Config.Ignore
    public static boolean enableTestBlocks;
    @Config.Comment(value={"Enable Iris Shaders [Requires Sodium]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableIris;
    @Config.Comment(value={"Enable MCPatcherForge features, still in Alpha. Individual features are toggled in mcpatcher.json"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableMCPatcherForgeFeatures;
    @Config.Comment(value={"Replace some vanilla render paths with more optimized versions. Disable if you encounter mixin conflicts."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableVBO;
    @Config.Comment(value={"Enable NotFine features"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableNotFineFeatures;
    @Config.Comment(value={"Tweak F3 screen to be closer to modern versions. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean modernizeF3Screen;
    @Config.Comment(value={"Show block registry name and meta value in F3, similar to 1.8+. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean showBlockDebugInfo;
    @Config.DefaultBoolean(value=true)
    @Config.Comment(value={"Hide downloading terrain screen. [From ArchaicFix]"})
    public static boolean hideDownloadingTerrainScreen;
    @Config.Comment(value={"Show memory usage during game load. [From ArchaicFix]"})
    @Config.DefaultBoolean(value=true)
    public static boolean showSplashMemoryBar;
    @Config.Comment(value={"Renders the HUD elements once per 20 frames (by default) and reuses the pixels to improve performance. [Experimental]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableHudCaching;
    @Config.Comment(value={"Inject a conditional early return into all RenderGameOverlayEvent receivers; Requires enableHudCaching"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableHudCachingEventTransformer;
    @Config.Comment(value={"The amount of frames to wait before updating the HUD elements. [Experimental]"})
    @Config.DefaultInt(value=20)
    @Config.RangeInt(min=1, max=60)
    public static int hudCachingFPS;
    @Config.Comment(value={"Batch drawScreen fonts [Experimental]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableFontRenderer;
    @Config.Comment(value={"Enable Dynamic Lights"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableDynamicLights;
    @Config.Comment(value={"Optimize world update light. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean optimizeWorldUpdateLight;
    @Config.Comment(value={"Speedup Animations. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean speedupAnimations;
    @Config.Comment(value={"Optimize Texture Loading. [From Hodgepodge]"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean optimizeTextureLoading;
    @Config.Comment(value={"Fix RenderBlockFluid reading the block type from the world access multiple times"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixFluidRendererCheckingBlockAgain;
    @Config.Comment(value={"Dynamically modifies the render distance of dropped items entities to preserve performance. It starts reducing the render distance when exceeding the threshold set below."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean dynamicItemRenderDistance;
    @Config.Comment(value={"Max amount of dropped item rendered"})
    @Config.DefaultInt(value=256)
    @Config.RangeInt(min=32, max=2048)
    public static int droppedItemLimit;
    @Config.Comment(value={"Use total world time instead of normal world time. Allows most shader animations to play when doDaylightCycle is off, but causes shader animations to desync from time of day."})
    @Config.DefaultBoolean(value=false)
    public static boolean useTotalWorldTime;
    @Config.Comment(value={"Enable Debug Logging"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableDebugLogging;
    @Config.Comment(value={"Enable Zoom"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean enableZoom;
    @Config.Comment(value={"Optimizes in-world item rendering [Experimental]"})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean optimizeInWorldItemRendering_WIP;
    @Config.Comment(value={"Max amount of display lists to cache for optimized item rendering. Higher number will use more VRAM"})
    @Config.DefaultInt(value=256)
    @Config.RangeInt(min=64, max=1024)
    public static int itemRendererDisplayListCacheSize;
    @Config.Comment(value={"Render distance for the spinning mob inside mod spawners"})
    @Config.DefaultDouble(value=16.0)
    @Config.RangeDouble(min=16.0, max=64.0)
    public static double mobSpawnerRenderDistance;
    @Config.Comment(value={"Switches to an alternate FPS limiter that gives more stable frametimes, in exchange for slightly more latency. Will never introduce more than one frame of latency, and has a lower impact at higher framerates."})
    @Config.DefaultBoolean(value=false)
    public static boolean sleepBeforeSwap;

    static {
        hudCachingFPS = 20;
    }
}

