/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.angelica.compat.mojang.ChunkPos;
import org.joml.Vector3i;

public class ChunkSectionPos
extends Vector3i {
    public static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    public static int getBlockCoord(int sectionCoord) {
        return sectionCoord << 4;
    }

    private ChunkSectionPos(int x, int y, int z) {
        super(x, y, z);
    }

    public static ChunkSectionPos from(int x, int y, int z) {
        return new ChunkSectionPos(x, y, z);
    }

    public static ChunkSectionPos from(BlockPos pos) {
        return new ChunkSectionPos(ChunkSectionPos.getSectionCoord(pos.getX()), ChunkSectionPos.getSectionCoord(pos.getY()), ChunkSectionPos.getSectionCoord(pos.getZ()));
    }

    public static long asLong(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & 0x3FFFFFL) << 42;
        l |= ((long)y & 0xFFFFFL) << 0;
        return l |= ((long)z & 0x3FFFFFL) << 20;
    }

    public static int getLocalCoord(int coord) {
        return coord & 0xF;
    }

    public static short packLocal(int x, int y, int z) {
        int i = ChunkSectionPos.getLocalCoord(x);
        int j = ChunkSectionPos.getLocalCoord(y);
        int k = ChunkSectionPos.getLocalCoord(z);
        return (short)(i << 8 | k << 4 | j << 0);
    }

    public long asLong() {
        return ChunkSectionPos.asLong(this.x, this.y, this.z);
    }

    public int getSectionX() {
        return this.x;
    }

    public int getSectionY() {
        return this.y;
    }

    public int getSectionZ() {
        return this.z;
    }

    public int getMinX() {
        return this.x << 4;
    }

    public int getMinY() {
        return this.y << 4;
    }

    public int getMinZ() {
        return this.z << 4;
    }

    public int getMaxX() {
        return (this.x << 4) + 15;
    }

    public int getMaxY() {
        return (this.y << 4) + 15;
    }

    public int getMaxZ() {
        return (this.z << 4) + 15;
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(this.getSectionX(), this.getSectionZ());
    }
}

