/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.font;

import com.gtnewhorizons.angelica.compat.lwjgl.CompatMemoryUtil;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.FontRendererAccessor;
import it.unimi.dsi.fastutil.chars.Char2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import jss.util.RandomXoshiro256StarStar;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class BatchingFontRenderer {
    protected FontRenderer underlying;
    private final ResourceLocation[] unicodePageLocations;
    protected int[] charWidth = new int[256];
    protected byte[] glyphWidth;
    private int[] colorCode;
    protected final ResourceLocation locationFontTexture;
    private final TextureManager renderEngine;
    private final RandomXoshiro256StarStar fontRandom = new RandomXoshiro256StarStar();
    private static final String MCFONT_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static final short[] MCFONT_ASCII_LUT = new short[512];
    private static final Char2ShortOpenHashMap MCFONT_UNI_LUT = new Char2ShortOpenHashMap();
    private int batchDepth = 0;
    private int vtxWriterIndex = 0;
    private int idxWriterIndex = 0;
    private static final int INITIAL_BATCH_SIZE = 256;
    private static final ResourceLocation DUMMY_RESOURCE_LOCATION;
    private FloatBuffer batchVtxPositions = BufferUtils.createFloatBuffer((int)512);
    private ByteBuffer batchVtxColors = BufferUtils.createByteBuffer((int)1024);
    private FloatBuffer batchVtxTexCoords = BufferUtils.createFloatBuffer((int)512);
    private IntBuffer batchIndices = BufferUtils.createIntBuffer((int)384);
    private final ObjectArrayList<FontDrawCmd> batchCommands = ObjectArrayList.wrap((Object[])new FontDrawCmd[64], (int)0);
    private final ObjectArrayList<FontDrawCmd> batchCommandPool = ObjectArrayList.wrap((Object[])new FontDrawCmd[64], (int)0);
    private static final char FORMATTING_CHAR = '\u00a7';

    public static int lookupMcFontPosition(char ch) {
        if (ch < MCFONT_ASCII_LUT.length) {
            return MCFONT_ASCII_LUT[ch];
        }
        return MCFONT_UNI_LUT.getOrDefault(ch, (short)-1);
    }

    public BatchingFontRenderer(FontRenderer underlying, ResourceLocation[] unicodePageLocations, int[] charWidth, byte[] glyphWidth, int[] colorCode, ResourceLocation locationFontTexture, TextureManager renderEngine) {
        this.underlying = underlying;
        this.unicodePageLocations = unicodePageLocations;
        this.charWidth = charWidth;
        this.glyphWidth = glyphWidth;
        this.colorCode = colorCode;
        this.locationFontTexture = locationFontTexture;
        this.renderEngine = renderEngine;
        for (int i = 0; i < 64; ++i) {
            this.batchCommandPool.add((Object)new FontDrawCmd());
        }
    }

    private void pushVtx(float x, float y, int rgba, float u, float v) {
        int oldCap = this.batchVtxPositions.capacity() / 2;
        if (this.vtxWriterIndex >= oldCap) {
            int newCap = oldCap * 2;
            this.batchVtxPositions = CompatMemoryUtil.memReallocDirect(this.batchVtxPositions, newCap * 2);
            this.batchVtxColors = CompatMemoryUtil.memReallocDirect(this.batchVtxColors, newCap * 4);
            this.batchVtxTexCoords = CompatMemoryUtil.memReallocDirect(this.batchVtxTexCoords, newCap * 2);
            int oldIdxCap = this.batchIndices.capacity();
            int newIdxCap = oldIdxCap * 2;
            this.batchIndices = CompatMemoryUtil.memReallocDirect(this.batchIndices, newIdxCap);
        }
        int idx = this.vtxWriterIndex++;
        int idx2 = idx * 2;
        int idx4 = idx * 4;
        this.batchVtxPositions.put(idx2, x);
        this.batchVtxPositions.put(idx2 + 1, y);
        this.batchVtxColors.put(idx4, (byte)(rgba >> 16 & 0xFF));
        this.batchVtxColors.put(idx4 + 1, (byte)(rgba >> 8 & 0xFF));
        this.batchVtxColors.put(idx4 + 2, (byte)(rgba & 0xFF));
        this.batchVtxColors.put(idx4 + 3, (byte)(rgba >> 24 & 0xFF));
        this.batchVtxTexCoords.put(idx2, u);
        this.batchVtxTexCoords.put(idx2 + 1, v);
    }

    private void pushUntexRect(float x, float y, float w, float h, int rgba) {
        int vtxId = this.vtxWriterIndex;
        this.pushVtx(x, y, rgba, 0.0f, 0.0f);
        this.pushVtx(x, y + h, rgba, 0.0f, 0.0f);
        this.pushVtx(x + w, y, rgba, 0.0f, 0.0f);
        this.pushVtx(x + w, y + h, rgba, 0.0f, 0.0f);
        this.pushQuadIdx(vtxId);
    }

    private int pushQuadIdx(int startV) {
        int idx = this.idxWriterIndex;
        this.batchIndices.put(idx, startV);
        this.batchIndices.put(idx + 1, startV + 1);
        this.batchIndices.put(idx + 2, startV + 2);
        this.batchIndices.put(idx + 3, startV + 2);
        this.batchIndices.put(idx + 4, startV + 1);
        this.batchIndices.put(idx + 5, startV + 3);
        this.idxWriterIndex += 6;
        return idx;
    }

    private void pushDrawCmd(int startIdx, int idxCount, ResourceLocation texture) {
        if (!this.batchCommands.isEmpty()) {
            FontDrawCmd lastCmd = (FontDrawCmd)this.batchCommands.get(this.batchCommands.size() - 1);
            int prevEndVtx = lastCmd.startVtx + lastCmd.idxCount;
            if (prevEndVtx == startIdx && lastCmd.texture == texture) {
                lastCmd.idxCount += idxCount;
                return;
            }
        }
        if (this.batchCommandPool.isEmpty()) {
            for (int i = 0; i < 64; ++i) {
                this.batchCommandPool.add((Object)new FontDrawCmd());
            }
        }
        FontDrawCmd cmd = (FontDrawCmd)this.batchCommandPool.pop();
        cmd.reset(startIdx, idxCount, texture);
        this.batchCommands.add((Object)cmd);
    }

    public void beginBatch() {
        if (this.batchDepth == Integer.MAX_VALUE) {
            throw new StackOverflowError("More than Integer.MAX_VALUE nested font rendering batch operations");
        }
        ++this.batchDepth;
    }

    public void endBatch() {
        if (this.batchDepth <= 0) {
            this.batchDepth = 0;
            return;
        }
        --this.batchDepth;
        if (this.batchDepth == 0) {
            this.flushBatch();
        }
    }

    private void flushBatch() {
        this.batchCommands.sort(FontDrawCmd.DRAW_ORDER_COMPARATOR);
        boolean isTextureEnabledBefore = GLStateManager.glIsEnabled(3553);
        int boundTextureBefore = GLStateManager.glGetInteger(32873);
        boolean textureChanged = false;
        ResourceLocation lastTexture = DUMMY_RESOURCE_LOCATION;
        GLStateManager.enableTexture();
        GLStateManager.enableAlphaTest();
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GLStateManager.glShadeModel(7424);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.batchVtxTexCoords);
        GL11.glEnableClientState((int)32888);
        GL11.glColorPointer((int)4, (int)5121, (int)0, (ByteBuffer)this.batchVtxColors);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)2, (int)0, (FloatBuffer)this.batchVtxPositions);
        GL11.glEnableClientState((int)32884);
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        FontDrawCmd[] cmdsData = (FontDrawCmd[])this.batchCommands.elements();
        int cmdsSize = this.batchCommands.size();
        for (int i = 0; i < cmdsSize; ++i) {
            FontDrawCmd cmd = cmdsData[i];
            if (!Objects.equals(lastTexture, cmd.texture)) {
                if (lastTexture == null) {
                    GLStateManager.glEnable(3553);
                } else if (cmd.texture == null) {
                    GLStateManager.glDisable(3553);
                }
                if (cmd.texture != null) {
                    ((FontRendererAccessor)this.underlying).angelica$bindTexture(cmd.texture);
                    textureChanged = true;
                }
                lastTexture = cmd.texture;
            }
            this.batchIndices.limit(cmd.startVtx + cmd.idxCount);
            this.batchIndices.position(cmd.startVtx);
            GL11.glDrawElements((int)4, (IntBuffer)this.batchIndices);
        }
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32884);
        if (isTextureEnabledBefore) {
            GLStateManager.glEnable(3553);
        }
        if (textureChanged) {
            GLStateManager.glBindTexture(3553, boundTextureBefore);
        }
        this.batchCommandPool.addAll(this.batchCommands);
        this.batchCommands.clear();
        this.vtxWriterIndex = 0;
        this.idxWriterIndex = 0;
        this.batchIndices.limit(this.batchIndices.capacity());
        this.batchIndices.position(0);
    }

    public static boolean charInRange(char what, char fromInclusive, char toInclusive) {
        return what >= fromInclusive && what <= toInclusive;
    }

    private ResourceLocation getUnicodePageLocation(int page) {
        ResourceLocation lookup = this.unicodePageLocations[page];
        if (lookup == null) {
            ResourceLocation rl;
            this.unicodePageLocations[page] = rl = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
            return rl;
        }
        return lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float drawString(float anchorX, float anchorY, int color, boolean enableShadow, boolean unicodeFlag, CharSequence string, int stringOffset, int stringLength) {
        if (string == null || string.length() == 0) {
            return anchorX + (enableShadow ? 1.0f : 0.0f);
        }
        int shadowColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        this.beginBatch();
        float curX = anchorX;
        try {
            int ulIdx;
            int totalStringLength = string.length();
            stringOffset = MathHelper.func_76125_a((int)stringOffset, (int)0, (int)totalStringLength);
            stringLength = MathHelper.func_76125_a((int)stringLength, (int)0, (int)(totalStringLength - stringOffset));
            if (stringLength <= 0) {
                float f = 0.0f;
                return f;
            }
            int stringEnd = stringOffset + stringLength;
            int curColor = color;
            int curShadowColor = shadowColor;
            boolean curItalic = false;
            boolean curRandom = false;
            boolean curBold = false;
            boolean curStrikethrough = false;
            boolean curUnderline = false;
            float underlineY = anchorY + (float)this.underlying.field_78288_b - 1.0f;
            float underlineStartX = 0.0f;
            float underlineEndX = 0.0f;
            float strikethroughY = anchorY + (float)(this.underlying.field_78288_b / 2) - 1.0f;
            float strikethroughStartX = 0.0f;
            float strikethroughEndX = 0.0f;
            for (int charIdx = stringOffset; charIdx < stringEnd; ++charIdx) {
                float vSz;
                float uSz;
                float xAdvance;
                float glyphW;
                float vStart;
                float uStart;
                ResourceLocation texture;
                float itOff;
                float shadowOffset;
                char chr = string.charAt(charIdx);
                if (chr == '\u00a7' && charIdx + 1 < stringEnd) {
                    int ulIdx2;
                    char fmtCode = Character.toLowerCase(string.charAt(charIdx + 1));
                    ++charIdx;
                    if (curUnderline && underlineStartX != underlineEndX) {
                        ulIdx2 = this.idxWriterIndex;
                        this.pushUntexRect(underlineStartX, underlineY, underlineEndX - underlineStartX, 1.0f, curColor);
                        this.pushDrawCmd(ulIdx2, 6, null);
                        underlineStartX = underlineEndX;
                    }
                    if (curStrikethrough && strikethroughStartX != strikethroughEndX) {
                        ulIdx2 = this.idxWriterIndex;
                        this.pushUntexRect(strikethroughStartX, strikethroughY, strikethroughEndX - strikethroughStartX, 1.0f, curColor);
                        this.pushDrawCmd(ulIdx2, 6, null);
                        strikethroughStartX = strikethroughEndX;
                    }
                    boolean is09 = BatchingFontRenderer.charInRange(fmtCode, '0', '9');
                    boolean isAF = BatchingFontRenderer.charInRange(fmtCode, 'a', 'f');
                    if (is09 || isAF) {
                        curRandom = false;
                        curBold = false;
                        curStrikethrough = false;
                        curUnderline = false;
                        curItalic = false;
                        int colorIdx = is09 ? fmtCode - 48 : fmtCode - 97 + 10;
                        int rgb = this.colorCode[colorIdx];
                        curColor = curColor & 0xFF000000 | rgb & 0xFFFFFF;
                        int shadowRgb = this.colorCode[colorIdx + 16];
                        curShadowColor = curShadowColor & 0xFF000000 | shadowRgb & 0xFFFFFF;
                        continue;
                    }
                    if (fmtCode == 'k') {
                        curRandom = true;
                        continue;
                    }
                    if (fmtCode == 'l') {
                        curBold = true;
                        continue;
                    }
                    if (fmtCode == 'm') {
                        curStrikethrough = true;
                        strikethroughEndX = strikethroughStartX = curX - 1.0f;
                        continue;
                    }
                    if (fmtCode == 'n') {
                        curUnderline = true;
                        underlineEndX = underlineStartX = curX - 1.0f;
                        continue;
                    }
                    if (fmtCode == 'o') {
                        curItalic = true;
                        continue;
                    }
                    if (fmtCode != 'r') continue;
                    curRandom = false;
                    curBold = false;
                    curStrikethrough = false;
                    curUnderline = false;
                    curItalic = false;
                    curColor = color;
                    curShadowColor = shadowColor;
                    continue;
                }
                int lutIndex = BatchingFontRenderer.lookupMcFontPosition(chr);
                if (curRandom && lutIndex != -1) {
                    int randomReplacementIndex;
                    while (this.charWidth[lutIndex] != this.charWidth[randomReplacementIndex = this.fontRandom.nextInt(this.charWidth.length)]) {
                    }
                    lutIndex = randomReplacementIndex;
                    chr = MCFONT_CHARS.charAt(lutIndex);
                }
                float f = shadowOffset = unicodeFlag ? 0.5f : 1.0f;
                if (chr == ' ' || chr == '\u00a0' || chr == '\u202f') {
                    curX += 4.0f;
                    continue;
                }
                float f2 = itOff = curItalic ? 1.0f : 0.0f;
                if (lutIndex == -1 || unicodeFlag) {
                    if (this.glyphWidth[chr] == 0) continue;
                    int uniPage = chr / 256;
                    texture = this.getUnicodePageLocation(uniPage);
                    int startColumn = this.glyphWidth[chr] >>> 4;
                    int endColumn = this.glyphWidth[chr] & 0xF;
                    float startColumnF = startColumn;
                    float endColumnF = endColumn + 1;
                    uStart = ((float)(chr % 16 * 16) + startColumnF) / 256.0f;
                    vStart = (float)((chr & 0xFF) / 16 * 16) / 256.0f;
                    float chrWidth = endColumnF - startColumnF - 0.02f;
                    glyphW = chrWidth / 2.0f + 1.0f;
                    xAdvance = (endColumnF - startColumnF) / 2.0f + 1.0f;
                    uSz = chrWidth / 256.0f;
                    vSz = 0.062421873f;
                } else {
                    uStart = (float)(lutIndex % 16 * 8) / 128.0f;
                    vStart = (float)(lutIndex / 16 * 8) / 128.0f;
                    xAdvance = this.charWidth[lutIndex];
                    if (xAdvance == 0.0f) continue;
                    glyphW = xAdvance - 0.01f;
                    uSz = (glyphW - 1.0f) / 128.0f;
                    vSz = 0.062421873f;
                    texture = this.locationFontTexture;
                }
                int vtxId = this.vtxWriterIndex;
                int idxId = this.idxWriterIndex;
                int vtxCount = 0;
                if (enableShadow) {
                    this.pushVtx(curX + itOff + shadowOffset, anchorY + shadowOffset, curShadowColor, uStart, vStart);
                    this.pushVtx(curX - itOff + shadowOffset, anchorY + 7.99f + shadowOffset, curShadowColor, uStart, vStart + vSz);
                    this.pushVtx(curX + glyphW - 1.0f + itOff + shadowOffset, anchorY + shadowOffset, curShadowColor, uStart + uSz, vStart);
                    this.pushVtx(curX + glyphW - 1.0f - itOff + shadowOffset, anchorY + 7.99f + shadowOffset, curShadowColor, uStart + uSz, vStart + vSz);
                    this.pushQuadIdx(vtxId + vtxCount);
                    vtxCount += 4;
                    if (curBold) {
                        float shadowOffset2 = 2.0f * shadowOffset;
                        this.pushVtx(curX + itOff + shadowOffset2, anchorY + shadowOffset, curShadowColor, uStart, vStart);
                        this.pushVtx(curX - itOff + shadowOffset2, anchorY + 7.99f + shadowOffset, curShadowColor, uStart, vStart + vSz);
                        this.pushVtx(curX + glyphW - 1.0f + itOff + shadowOffset2, anchorY + shadowOffset, curShadowColor, uStart + uSz, vStart);
                        this.pushVtx(curX + glyphW - 1.0f - itOff + shadowOffset2, anchorY + 7.99f + shadowOffset, curShadowColor, uStart + uSz, vStart + vSz);
                        this.pushQuadIdx(vtxId + vtxCount);
                        vtxCount += 4;
                    }
                }
                this.pushVtx(curX + itOff, anchorY, curColor, uStart, vStart);
                this.pushVtx(curX - itOff, anchorY + 7.99f, curColor, uStart, vStart + vSz);
                this.pushVtx(curX + glyphW - 1.0f + itOff, anchorY, curColor, uStart + uSz, vStart);
                this.pushVtx(curX + glyphW - 1.0f - itOff, anchorY + 7.99f, curColor, uStart + uSz, vStart + vSz);
                this.pushQuadIdx(vtxId + vtxCount);
                vtxCount += 4;
                if (curBold) {
                    this.pushVtx(shadowOffset + curX + itOff, anchorY, curColor, uStart, vStart);
                    this.pushVtx(shadowOffset + curX - itOff, anchorY + 7.99f, curColor, uStart, vStart + vSz);
                    this.pushVtx(shadowOffset + curX + glyphW - 1.0f + itOff, anchorY, curColor, uStart + uSz, vStart);
                    this.pushVtx(shadowOffset + curX + glyphW - 1.0f - itOff, anchorY + 7.99f, curColor, uStart + uSz, vStart + vSz);
                    this.pushQuadIdx(vtxId + vtxCount);
                    vtxCount += 4;
                }
                this.pushDrawCmd(idxId, vtxCount / 2 * 3, texture);
                underlineEndX = curX += xAdvance + (curBold ? shadowOffset : 0.0f);
                strikethroughEndX = curX;
            }
            if (curUnderline && underlineStartX != underlineEndX) {
                ulIdx = this.idxWriterIndex;
                this.pushUntexRect(underlineStartX, underlineY, underlineEndX - underlineStartX, 1.0f, curColor);
                this.pushDrawCmd(ulIdx, 6, null);
            }
            if (curStrikethrough && strikethroughStartX != strikethroughEndX) {
                ulIdx = this.idxWriterIndex;
                this.pushUntexRect(strikethroughStartX, strikethroughY, strikethroughEndX - strikethroughStartX, 1.0f, curColor);
                this.pushDrawCmd(ulIdx, 6, null);
            }
        }
        finally {
            this.endBatch();
        }
        return curX + (enableShadow ? 1.0f : 0.0f);
    }

    static {
        Arrays.fill(MCFONT_ASCII_LUT, (short)-1);
        for (short i = 0; i < MCFONT_CHARS.length(); i = (short)(i + 1)) {
            char ch = MCFONT_CHARS.charAt(i);
            if (ch < MCFONT_ASCII_LUT.length) {
                BatchingFontRenderer.MCFONT_ASCII_LUT[ch] = i;
                continue;
            }
            MCFONT_UNI_LUT.put(ch, i);
        }
        DUMMY_RESOURCE_LOCATION = new ResourceLocation("angelica$dummy", "this is invalid!");
    }

    private static final class FontDrawCmd {
        public int startVtx;
        public int idxCount;
        public ResourceLocation texture;
        public static final Comparator<FontDrawCmd> DRAW_ORDER_COMPARATOR = Comparator.comparing(fdc -> fdc.texture, Comparator.nullsLast(Comparator.comparing(ResourceLocation::func_110624_b).thenComparing(ResourceLocation::func_110623_a))).thenComparing(fdc -> fdc.startVtx);

        private FontDrawCmd() {
        }

        public void reset(int startVtx, int vtxCount, ResourceLocation texture) {
            this.startVtx = startVtx;
            this.idxCount = vtxCount;
            this.texture = texture;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FontDrawCmd that = (FontDrawCmd)obj;
            return this.startVtx == that.startVtx && this.idxCount == that.idxCount && Objects.equals(this.texture, that.texture);
        }

        public int hashCode() {
            return Objects.hash(this.startVtx, this.idxCount, this.texture);
        }

        public String toString() {
            return "FontDrawCmd[startVtx=" + this.startVtx + ", vtxCount=" + this.idxCount + ", texture=" + this.texture + ']';
        }
    }
}

