/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.trophy;

import glowredman.amazingtrophies.api.AmazingTrophiesAPI;
import glowredman.amazingtrophies.api.TrophyModelHandler;
import glowredman.amazingtrophies.api.TrophyProperties;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import glowredman.amazingtrophies.trophy.TileEntityTrophy;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;

public class RendererTrophy
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final TrophyModelHandler FALLBACK_MODEL_HANDLER = new PedestalTrophyModelHandler();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTickTime) {
        TrophyModelHandler modelHandler;
        TileEntityTrophy tileTrophy = (TileEntityTrophy)tileEntity;
        TrophyProperties props = tileTrophy.getProperties();
        TrophyModelHandler trophyModelHandler = modelHandler = props == null ? FALLBACK_MODEL_HANDLER : props.getModelHandler();
        if (modelHandler == null) {
            return;
        }
        modelHandler.render(x + 0.5, y + 0.5, z + 0.5, tileTrophy.func_145832_p(), tileTrophy.getPlayerName(), tileTrophy.getTime(), partialTickTime);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        TrophyModelHandler modelHandler = FALLBACK_MODEL_HANDLER;
        String name = null;
        long time = 0L;
        if (item.func_77942_o()) {
            TrophyProperties props;
            NBTTagCompound nbt = item.func_77978_p();
            String id = nbt.func_74779_i("trophyID");
            if (!id.isEmpty() && (props = AmazingTrophiesAPI.getTrophyProperties(id)) != null && (modelHandler = props.getModelHandler()) == null) {
                return;
            }
            name = nbt.func_74779_i("name");
            time = nbt.func_74763_f("time");
        }
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                modelHandler.render(0.5, 0.5, 0.5, 12, name, time, 0.0f);
                break;
            }
            default: {
                modelHandler.render(0.0, 0.0, 0.0, 12, name, time, 0.0f);
            }
        }
    }
}

