/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import glowredman.amazingtrophies.AmazingTrophies;
import glowredman.amazingtrophies.api.ItemDefinition;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import org.apache.commons.lang3.StringUtils;

public class ConfigHandler {
    public static final String PROPERTY_REGISTRY_NAME = "registryName";
    public static final String PROPERTY_META = "meta";
    public static final String PROPERTY_NBT = "nbt";
    private static final JsonParser PARSER = new JsonParser();
    private static final Comparator<Path> COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path o1, Path o2) {
            return this.compare(AmazingTrophies.CONFIG_DIR.relativize(o1).toString(), AmazingTrophies.CONFIG_DIR.relativize(o2).toString());
        }

        @Override
        private int compare(String o1, String o2) {
            String dir2;
            int index1 = o1.indexOf(47);
            int index2 = o2.indexOf(47);
            if (index1 == -1) {
                index1 = o1.indexOf(92);
            }
            if (index2 == -1) {
                index2 = o2.indexOf(92);
            }
            if (index1 == -1) {
                if (index2 == -1) {
                    return o1.compareToIgnoreCase(o2);
                }
                return 1;
            }
            if (index2 == -1) {
                return -1;
            }
            String dir1 = o1.substring(0, index1);
            int i = dir1.compareToIgnoreCase(dir2 = o2.substring(0, index2));
            if (i == 0) {
                return this.compare(o1.substring(index1 + 1), o2.substring(index2 + 1));
            }
            return i;
        }
    };

    static void parseOrCreate(String directoryName, Consumer<JsonElement> action) {
        Path dir = AmazingTrophies.CONFIG_DIR.resolve(directoryName);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (Exception e) {
            AmazingTrophies.LOGGER.error("Failed to create directory " + dir + "!", (Throwable)e);
            return;
        }
        try (Stream<Path> files = Files.walk(dir, new FileVisitOption[0]);){
            files.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && StringUtils.endsWithIgnoreCase((CharSequence)path.getFileName().toString(), (CharSequence)".json")).sorted(COMPARATOR).forEachOrdered(path -> ConfigHandler.parseFile(path, action));
        }
        catch (Exception e) {
            AmazingTrophies.LOGGER.error("Failed to list files in " + dir + "!", (Throwable)e);
        }
    }

    private static void parseFile(Path path, Consumer<JsonElement> action) {
        try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path));){
            action.accept(PARSER.parse(reader));
        }
        catch (Exception e) {
            AmazingTrophies.LOGGER.error("Failed to parse " + AmazingTrophies.CONFIG_DIR.relativize(path) + "!", (Throwable)e);
        }
    }

    public static Class<? extends Entity> parseEntityClass(JsonElement json) {
        String name = json.getAsString();
        Class<?> clazz = (Class<?>)EntityList.field_75625_b.get(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find target class!", e);
        }
        if (Entity.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException(name + " is not a subclass of " + Entity.class.getName() + "!");
    }

    public static Class<? extends EntityLivingBase> parseEntityLivingClass(JsonElement element) {
        String className = element.getAsString();
        Class<?> clazz = (Class<?>)EntityList.field_75625_b.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find target class!", e);
            }
        }
        if (EntityLivingBase.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException(className + " is not a subclass of " + EntityLivingBase.class.getName() + "!");
    }

    public static <T> T getProperty(JsonObject json, String key, Function<JsonElement, T> parser) {
        JsonElement element = json.get(key);
        if (element == null || element.isJsonNull()) {
            throw new JsonSyntaxException("Required property \"" + key + "\" is missing!");
        }
        return parser.apply(element);
    }

    public static int getIntegerProperty(JsonObject json, String key) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsInt);
    }

    public static ItemDefinition getItemProperty(JsonObject json, String key, int defaultMeta) {
        JsonObject definitionJson = json.getAsJsonObject(key);
        return new ItemDefinition(ConfigHandler.getStringProperty(definitionJson, PROPERTY_REGISTRY_NAME), ConfigHandler.getIntegerProperty(definitionJson, PROPERTY_META, defaultMeta), ConfigHandler.getStringProperty(definitionJson, PROPERTY_NBT, null));
    }

    public static JsonObject getObjectProperty(JsonObject json, String key) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsJsonObject);
    }

    public static <T> Set<T> getSetProperty(JsonObject json, String key, Function<JsonElement, T> parser) {
        return ConfigHandler.getProperty(json, key, jsonElement -> {
            HashSet set = new HashSet();
            if (jsonElement.isJsonPrimitive()) {
                set.add(parser.apply((JsonElement)jsonElement));
                return set;
            }
            JsonArray array = jsonElement.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                set.add(parser.apply(array.get(i)));
            }
            return set;
        });
    }

    public static String getStringProperty(JsonObject json, String key) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsString);
    }

    public static <T> T getProperty(JsonObject json, String key, Function<JsonElement, T> parser, T fallback) {
        JsonElement element = json.get(key);
        if (element == null) {
            return fallback;
        }
        if (element.isJsonNull()) {
            return null;
        }
        return parser.apply(element);
    }

    public static boolean getBooleanProperty(JsonObject json, String key, boolean fallback) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsBoolean, fallback);
    }

    public static double getDoubleProperty(JsonObject json, String key, double fallback) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsDouble, fallback);
    }

    public static float getFloatProperty(JsonObject json, String key, float fallback) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsFloat, Float.valueOf(fallback)).floatValue();
    }

    public static int getIntegerProperty(JsonObject json, String key, int fallback) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsInt, fallback);
    }

    public static <T> Set<T> getSetProperty(JsonObject json, String key, Function<JsonElement, T> parser, Set<T> fallback) {
        return ConfigHandler.getProperty(json, key, jsonElement -> {
            HashSet set = new HashSet();
            if (jsonElement.isJsonPrimitive()) {
                set.add(parser.apply((JsonElement)jsonElement));
                return set;
            }
            JsonArray array = jsonElement.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                set.add(parser.apply(array.get(i)));
            }
            return set;
        }, fallback);
    }

    public static String getStringProperty(JsonObject json, String key, String fallback) {
        return ConfigHandler.getProperty(json, key, JsonElement::getAsString, fallback);
    }
}

