/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellUpgrades;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public abstract class ItemBaseInfinityStorageCell
extends AEBaseItem
implements IStorageFluidCell {
    @Override
    public long getBytes(ItemStack cellItem) {
        return 0L;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 0;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return 0.0;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 0;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof IFluidCellInventoryHandler) {
            IFluidCellInventoryHandler handler = (IFluidCellInventoryHandler)inventory;
            IFluidCellInventory cellInventory = handler.getCellInv();
            if (GuiScreen.func_146271_m()) {
                if (!cellInventory.getContents().isEmpty()) {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_contents"));
                    for (IAEFluidStack fluid : cellInventory.getContents()) {
                        if (fluid == null) continue;
                        lines.add(String.format("  %s %s", StatCollector.func_74838_a((String)"ae2fc.tooltip.infinity_fluid"), fluid.getFluidStack().getLocalizedName()));
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_empty"));
                }
            } else {
                lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.ctrl_for_more"));
            }
        }
    }
}

