/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.base.FCContainerMonitor;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerItemMonitor
extends FCContainerMonitor<IAEItemStack> {
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();

    public ContainerItemMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected ContainerItemMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable, bindInventory);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            if (monitorable instanceof IGridHost) {
                IGridNode node = ((IGridHost)monitorable).getGridNode(ForgeDirection.UNKNOWN);
                if (node != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                        IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                        this.monitor = storageGrid.getItemInventory();
                        if (this.monitor == null) {
                            this.setValidContainer(false);
                        } else {
                            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                            this.setCellInventory((IMEInventoryHandler)this.monitor);
                        }
                    }
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.monitor = monitorable.getItemInventory();
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler)this.monitor);
                this.setPowerSource((IEnergySource)monitorable);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    @Override
    protected void processItemList() {
        if (!this.items.isEmpty()) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : this.items) {
                IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                toSend.add(is);
            }
            for (Object c : this.field_75149_d) {
                if (!(c instanceof EntityPlayer)) continue;
                SPacketMEUpdateBuffer.scheduleItemUpdate((EntityPlayerMP)c, toSend);
            }
            this.items.resetStatus();
        }
    }

    @Override
    protected void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : monitorCache) {
                toSend.add(is);
            }
            SPacketMEUpdateBuffer.scheduleItemUpdate((EntityPlayerMP)c, toSend);
        }
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            if (c instanceof EntityPlayerMP) {
                SPacketMEUpdateBuffer.clear((EntityPlayerMP)c);
            }
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }
}

