/*
 * Decompiled with CFR 0.152.
 */
package witchinggadgets.common.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.config.ConfigItems;
import witchinggadgets.common.blocks.tiles.TileEntityLabelLibrary;
import witchinggadgets.common.gui.SlotOutput;

public class ContainerLabelLibrary
extends Container {
    private static final int LABEL_INPUT_SLOT = 0;
    private static final int LABEL_OUTPUT_SLOT = 1;
    private static final int SLOT_COUNT = 2;
    protected final TileEntityLabelLibrary tileEntity;

    public ContainerLabelLibrary(InventoryPlayer inventoryPlayer, TileEntityLabelLibrary te) {
        this.tileEntity = te;
        this.func_75146_a(new Slot(this.tileEntity, 0, 8, 8){

            public boolean func_75214_a(ItemStack stack) {
                return ContainerLabelLibrary.this.isLabel(stack);
            }
        });
        this.func_75146_a(new SlotOutput(this.tileEntity, 1, 8, 51){

            public void func_82870_a(EntityPlayer player, ItemStack stack) {
                this.field_75224_c.func_70298_a(0, 1);
            }
        });
        this.bindPlayerInventory(inventoryPlayer);
    }

    private boolean isLabel(ItemStack stack) {
        return stack != null && stack.func_77973_b().equals(ConfigItems.itemResource) && stack.func_77960_j() == 13;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileEntity.func_70300_a(player);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slot);
        switch (slot) {
            case 0: {
                return this.transferLabelsWithAspect(new AspectList());
            }
            case 1: {
                if (clickedSlot.func_75216_d()) {
                    ItemStack clickedStack = clickedSlot.func_75211_c();
                    AspectList aspects = ((IEssentiaContainerItem)clickedStack.func_77973_b()).getAspects(clickedStack);
                    return this.transferLabelsWithAspect(aspects);
                }
                return null;
            }
        }
        this.transferInventoryToLabels(clickedSlot);
        return null;
    }

    private void transferInventoryToLabels(Slot clickedSlot) {
        ItemStack clickedItem = clickedSlot.func_75211_c();
        if (this.isLabel(clickedItem)) {
            Slot labelSlot = (Slot)this.field_75151_b.get(0);
            ItemStack labels = labelSlot.func_75211_c();
            if (labels == null) {
                ((IEssentiaContainerItem)clickedItem.func_77973_b()).setAspects(clickedItem, new AspectList());
                labelSlot.func_75215_d(clickedItem);
                clickedSlot.func_75209_a(clickedItem.field_77994_a);
            } else {
                int amountToTransfer = Math.min(labels.func_77976_d() - labels.field_77994_a, clickedItem.field_77994_a);
                if (amountToTransfer == 0) {
                    return;
                }
                labels.field_77994_a += amountToTransfer;
                labelSlot.func_75215_d(labels);
                clickedSlot.func_75209_a(amountToTransfer);
            }
        }
    }

    private ItemStack transferLabelsWithAspect(AspectList aspects) {
        Slot labelSlot = (Slot)this.field_75151_b.get(0);
        ItemStack labels = labelSlot.func_75211_c();
        ItemStack returnStack = null;
        if (labelSlot.func_75216_d()) {
            ((IEssentiaContainerItem)labels.func_77973_b()).setAspects(labels, aspects);
            returnStack = labels.func_77946_l();
            if (!this.func_75135_a(labels, 2, this.field_75151_b.size(), true)) {
                ((IEssentiaContainerItem)labels.func_77973_b()).setAspects(labels, new AspectList());
                return null;
            }
            if (labels.field_77994_a == 0) {
                labelSlot.func_75215_d(null);
            } else {
                labelSlot.func_75218_e();
            }
            ((IEssentiaContainerItem)labels.func_77973_b()).setAspects(labels, new AspectList());
        }
        return returnStack;
    }

    public ItemStack func_75144_a(int slotId, int dragType, int clickTypeIn, EntityPlayer player) {
        ItemStack heldStack = player.field_71071_by.func_70445_o();
        if (slotId == 0 && heldStack != null) {
            Slot labelSlot = (Slot)this.field_75151_b.get(slotId);
            ItemStack labels = labelSlot.func_75211_c();
            if (labelSlot.func_75214_a(heldStack)) {
                if (labels == null) {
                    ((IEssentiaContainerItem)heldStack.func_77973_b()).setAspects(heldStack, new AspectList());
                    labelSlot.func_75215_d(heldStack);
                    heldStack = null;
                } else {
                    int amountToTransfer = Math.min(labels.func_77976_d() - labels.field_77994_a, heldStack.field_77994_a);
                    labels.field_77994_a += amountToTransfer;
                    labelSlot.func_75215_d(labels);
                    heldStack.field_77994_a -= amountToTransfer;
                    if (heldStack.field_77994_a == 0) {
                        heldStack = null;
                    }
                }
                player.field_71071_by.func_70437_b(heldStack);
            }
            return heldStack;
        }
        return super.func_75144_a(slotId, dragType, clickTypeIn, player);
    }
}

