/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.asm;

import alkalus.main.asm.AsmConfig;
import alkalus.main.asm.transformer.ClassTransformer_Witchery_NEIWitcheryConfig;
import alkalus.main.asm.transformer.ClassTransformer_Witchery_TileEntityPoppetShelf;
import alkalus.main.asm.transformer.ClassTransformer_Witchery_TileEntityWitchesOven;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;

public class WE_CORE_Handler
implements IClassTransformer {
    public static final AsmConfig mConfig = new AsmConfig(new File("config/WitcheryExtras/asm.cfg"));
    private static Boolean mObf;

    public boolean checkObfuscated() {
        if (mObf != null) {
            return mObf;
        }
        boolean obfuscated = false;
        try {
            obfuscated = (Boolean)ReflectionHelper.findField(CoreModManager.class, (String[])new String[]{"deobfuscatedEnvironment"}).get(null) == false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            try {
                byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
                obfuscated = bs == null;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                obfuscated = false;
            }
        }
        mObf = obfuscated;
        return obfuscated;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean obfuscated = this.checkObfuscated();
        if (transformedName.equals("com.emoniph.witchery.integration.NEIWitcheryConfig")) {
            if (AsmConfig.enablePatchNEI) {
                return new ClassTransformer_Witchery_NEIWitcheryConfig(transformedName, basicClass, obfuscated).getWriter().toByteArray();
            }
        }
        if (transformedName.equals("com.emoniph.witchery.blocks.BlockWitchesOven$TileEntityWitchesOven")) {
            return new ClassTransformer_Witchery_TileEntityWitchesOven(transformedName, basicClass, obfuscated).getWriter().toByteArray();
        }
        if (transformedName.equals("com.emoniph.witchery.blocks.BlockPoppetShelf$TileEntityPoppetShelf")) {
            return new ClassTransformer_Witchery_TileEntityPoppetShelf(transformedName, basicClass, obfuscated).getWriter().toByteArray();
        }
        return basicClass;
    }

    static {
        System.out.println("[Witchery++][ASM] Asm Config Location: " + AsmConfig.config.getConfigFile().getAbsolutePath());
        mObf = null;
    }
}

